package com.live.server.controller;

import com.live.common.domain.ResponseData;
import com.live.common.domain.request.*;
import com.live.common.service.UserService;
import io.swagger.annotations.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

@Slf4j
@CrossOrigin
@RestController
@RequestMapping("/user")
@Api(tags = "用户接口 API 文档")
public class UserController {

    @Resource
    private UserService userService;

    @PostMapping(value = "/sendSms")
    @ApiOperation(value = "发送注册短信验证码接口", notes = "发送注册短信验证码接口")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    public ResponseData<?> sendSms(@RequestBody @Validated SendSmsRequest sendSmsRequest, HttpServletRequest request) {
        return userService.sendSms(sendSmsRequest, request);
    }

    @PostMapping(value = "/register")
    @ApiOperation(value = "用户手机号注册 / 登录接口", notes = "用户手机号注册 / 登录接口")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    public ResponseData<?> register(@RequestBody @Validated RegisterRequest registerRequest, HttpServletRequest request) {
        return userService.register(registerRequest, request);
    }

//    @PostMapping(value = "/userInfoByIds")
//    @ApiOperation(value = "根据用户id获取用户信息", notes = "根据用户id获取用户信息")
//    @ApiResponses({
//            @ApiResponse(code = 200, message = "成功处理请求"),
//            @ApiResponse(code = 401, message = "没有权限访问该服务"),
//            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
//            @ApiResponse(code = 404, message = "未发现该服务"),
//            @ApiResponse(code = 500, message = "服务器内部错误")
//    })
//    public ResponseData<?> userInfoById(@RequestBody UserInfoByIdRequest ids,HttpServletRequest request) {
//        return userService.userInfoById(ids, request);
//    }

    @PostMapping(value = "/registerByPc")
    @ApiOperation(value = "PC 版 用户手机号密码注册")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    public ResponseData<?> registerByPc(@RequestBody @Validated RegisterPcRequest registerRequest, HttpServletRequest request) {
        return userService.registerByPc(registerRequest, request);
    }

    @PostMapping(value = "/loginByPwd")
    @ApiOperation(value = "密码登录")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    public ResponseData<?> loginByPc(@RequestBody @Validated LoginPcRequest loginPcRequest, HttpServletRequest request) {
        return userService.loginByPc(loginPcRequest, request);
    }

//    @PostMapping(value = "/updatePhoneSt")
//    @ApiOperation(value = "PC 版 改绑手机 步骤一 确认验证码")
//    @ApiResponses({
//            @ApiResponse(code = 200, message = "成功处理请求"),
//            @ApiResponse(code = 401, message = "没有权限访问该服务"),
//            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
//            @ApiResponse(code = 404, message = "未发现该服务"),
//            @ApiResponse(code = 500, message = "服务器内部错误")
//    })
//    @ApiImplicitParams({
//            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
//    })
//    public ResponseData<?> updatePhoneSt(@RequestBody @Validated UpdatePhoneStRequest loginPcRequest, HttpServletRequest request) {
//        return userService.updatePhoneSt(loginPcRequest, request);
//    }
//
//    @PostMapping(value = "/updatePhoneNd")
//    @ApiOperation(value = "PC 版 改绑手机 步骤二 确认修改手机号")
//    @ApiResponses({
//            @ApiResponse(code = 200, message = "成功处理请求"),
//            @ApiResponse(code = 401, message = "没有权限访问该服务"),
//            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
//            @ApiResponse(code = 404, message = "未发现该服务"),
//            @ApiResponse(code = 500, message = "服务器内部错误")
//    })
//    @ApiImplicitParams({
//            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
//    })
//    public ResponseData<?> updatePhoneNd(@RequestBody @Validated UpdatePhoneNdRequest loginPcRequest, HttpServletRequest request) {
//        return userService.updatePhoneNd(loginPcRequest, request);
//    }
//
//    @PostMapping(value = "/updatePhoneByApp")
//    @ApiOperation(value = "APP 版 改绑手机")
//    @ApiResponses({
//            @ApiResponse(code = 200, message = "成功处理请求"),
//            @ApiResponse(code = 401, message = "没有权限访问该服务"),
//            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
//            @ApiResponse(code = 404, message = "未发现该服务"),
//            @ApiResponse(code = 500, message = "服务器内部错误")
//    })
//    @ApiImplicitParams({
//            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
//    })
//    public ResponseData<?> updatePhoneByApp(@RequestBody @Validated UpdatePhoneByAppRequest loginPcRequest, HttpServletRequest request) {
//        return userService.updatePhoneByApp(loginPcRequest, request);
//    }
//
    @PostMapping(value = "/forgotPassword")
    @ApiOperation(value = "PC 版 忘记密码")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    public ResponseData<?> forgotPassword(@RequestBody @Validated ForgotPasswordRequest forgotPasswordRequest, HttpServletRequest request) {
        return userService.forgotPassword(forgotPasswordRequest, request);
    }

    @PostMapping(value = "/loginOut")
    @ApiOperation(value = "用户退出登录")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> loginOut(HttpServletRequest request) {
        return userService.loginOut(request);
    }

    @PostMapping(value = "/userInfo")
    @ApiOperation(value = "用户信息", notes = "用户信息")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> userInfo(HttpServletRequest request) {
        return userService.userInfo(request);
    }

    @PostMapping(value = "/editUserInfo")
    @ApiOperation(value = "修改用户信息", notes = "修改用户信息")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> editUserInfo(@RequestBody EditUserInfoRequest userInfoRequest, HttpServletRequest request) {
        return userService.editUserInfo(userInfoRequest, request);
    }

    @PostMapping(value = "/editUserAvatar")
    @ApiOperation(value = "修改用户头像", notes = "修改用户头像")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> editUserAvatar(@RequestBody @Validated EditUserAvatarRequest avatarRequest, HttpServletRequest request) {
        return userService.editUserAvatar(avatarRequest, request);
    }

//    @PostMapping(value = "/getFeedbackList")
//    @ApiOperation(value = "获取反馈类型")
//    @ApiResponses({
//            @ApiResponse(code = 200, message = "成功处理请求"),
//            @ApiResponse(code = 401, message = "没有权限访问该服务"),
//            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
//            @ApiResponse(code = 404, message = "未发现该服务"),
//            @ApiResponse(code = 500, message = "服务器内部错误")
//    })
//    public ResponseData<?> getFeedbackList() {
//        return userService.getFeedbackList();
//    }
//
//    @PostMapping(value = "/userFeedback")
//    @ApiOperation(value = "用户反馈")
//    @ApiResponses({
//            @ApiResponse(code = 200, message = "成功处理请求"),
//            @ApiResponse(code = 401, message = "没有权限访问该服务"),
//            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
//            @ApiResponse(code = 404, message = "未发现该服务"),
//            @ApiResponse(code = 500, message = "服务器内部错误")
//    })
//    @ApiImplicitParams({
//            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
//    })
//    public ResponseData<?> userFeedback(@RequestBody FeedbackRequest feedbackRequest, HttpServletRequest request) {
//        return userService.userFeedback(feedbackRequest, request);
//    }
//
//    @PostMapping(value = "/getUserFeedbackList")
//    @ApiOperation(value = "获取用户反馈")
//    @ApiResponses({
//            @ApiResponse(code = 200, message = "成功处理请求"),
//            @ApiResponse(code = 401, message = "没有权限访问该服务"),
//            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
//            @ApiResponse(code = 404, message = "未发现该服务"),
//            @ApiResponse(code = 500, message = "服务器内部错误")
//    })
//    @ApiImplicitParams({
//            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
//    })
//    public ResponseData<?> getUserFeedbackList(HttpServletRequest request) {
//        return userService.getUserFeedbackList(request);
//    }
//
//    @PostMapping(value = "/userApplyAnchor")
//    @ApiOperation(value = "用户申请成为主播")
//    @ApiResponses({
//            @ApiResponse(code = 200, message = "成功处理请求"),
//            @ApiResponse(code = 401, message = "没有权限访问该服务"),
//            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
//            @ApiResponse(code = 404, message = "未发现该服务"),
//            @ApiResponse(code = 500, message = "服务器内部错误")
//    })
//    @ApiImplicitParams({
//            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
//    })
//    public ResponseData<?> userApplyAnchor(@RequestBody @Validated UserApplyAnchorRequest userApplyAnchorRequest, HttpServletRequest request) {
//        return userService.userApplyAnchor(userApplyAnchorRequest, request);
//    }

//    @PostMapping(value = "/getUserMsgList")
//    @ApiOperation(value = "获取用户消息列表")
//    @ApiResponses({
//            @ApiResponse(code = 200, message = "成功处理请求"),
//            @ApiResponse(code = 401, message = "没有权限访问该服务"),
//            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
//            @ApiResponse(code = 404, message = "未发现该服务"),
//            @ApiResponse(code = 500, message = "服务器内部错误")
//    })
//    @ApiImplicitParams({
//            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
//    })
//    public ResponseData<?> getUserMsgList(@RequestBody CommonPage commonPage, HttpServletRequest request) {
//        return userService.getUserMsgList(commonPage, request);
//    }
//
//    @PostMapping(value = "/updateMsgStatus")
//    @ApiOperation(value = "修改消息已读根据消息 id 数组")
//    @ApiResponses({
//            @ApiResponse(code = 200, message = "成功处理请求"),
//            @ApiResponse(code = 401, message = "没有权限访问该服务"),
//            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
//            @ApiResponse(code = 404, message = "未发现该服务"),
//            @ApiResponse(code = 500, message = "服务器内部错误")
//    })
//    @ApiImplicitParams({
//            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
//    })
//    public ResponseData<?> updateMsgStatus(@RequestBody UserMsgRequest userMsgRequest, HttpServletRequest request) {
//        return userService.updateMsgStatus(userMsgRequest, request);
//    }

}
