package com.live.common.utils;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.qcloud.cos.utils.Md5Utils;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.SecureRandom;

/**
 * 支持SHA-1/MD5消息摘要的工具类.
 * 
 * 返回ByteSource，可进一步被编码为Hex, Base64或UrlSafeBase64
 * 
 * @author calvin
 */
public class MD5Util {

	private static final String SHA1 = "SHA-1";
	private static final String MD5 = "MD5";

	private static SecureRandom random = new SecureRandom();

	/**
	 * 对输入字符串进行md5散列.
	 */
	public static byte[] md5(byte[] input) {
		return digest(input, MD5, null, 1);
	}
	public static byte[] md5(byte[] input, int iterations) {
		return digest(input, MD5, null, iterations);
	}
	
	/**
	 * 对输入字符串进行sha1散列.
	 */
	public static byte[] sha1(byte[] input) {
		return digest(input, SHA1, null, 1);
	}

	public static byte[] sha1(byte[] input, byte[] salt) {
		return digest(input, SHA1, salt, 1);
	}

	public static byte[] sha1(byte[] input, byte[] salt, int iterations) {
		return digest(input, SHA1, salt, iterations);
	}

	/**
	 * 对字符串进行散列, 支持md5与sha1算法.
	 */
	private static byte[] digest(byte[] input, String algorithm, byte[] salt, int iterations) {
		try {
			MessageDigest digest = MessageDigest.getInstance(algorithm);

			if (salt != null) {
				digest.update(salt);
			}

			byte[] result = digest.digest(input);

			for (int i = 1; i < iterations; i++) {
				digest.reset();
				result = digest.digest(result);
			}
			return result;
		} catch (GeneralSecurityException e) {
			e.printStackTrace();
		}
		return null;
	}

	private static byte[] digest(InputStream input, String algorithm) throws IOException {
		try {
			MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
			int bufferLength = 8 * 1024;
			byte[] buffer = new byte[bufferLength];
			int read = input.read(buffer, 0, bufferLength);

			while (read > -1) {
				messageDigest.update(buffer, 0, read);
				read = input.read(buffer, 0, bufferLength);
			}

			return messageDigest.digest();
		} catch (GeneralSecurityException e) {
			e.printStackTrace();
		}
		return null;
	}

	public static String string2MD5(String inStr){
		if(StringUtils.isBlank(inStr)){
			return null;
		}
		MessageDigest md5 = null;
		try{
			md5 = MessageDigest.getInstance("MD5");
		}catch (Exception e){
			System.out.println(e.toString());
			e.printStackTrace();
			return "";
		}
		char[] charArray = inStr.toCharArray();
		byte[] byteArray = new byte[charArray.length];

		for (int i = 0; i < charArray.length; i++) {
			byteArray[i] = (byte) charArray[i];
		}
		byte[] md5Bytes = md5.digest(byteArray);
		StringBuffer hexValue = new StringBuffer();
		for (int i = 0; i < md5Bytes.length; i++){
			int val = ((int) md5Bytes[i]) & 0xff;
			if (val < 16) {
				hexValue.append("0");
			}
			hexValue.append(Integer.toHexString(val));
		}
		return hexValue.toString();

	}
	
	public static void main(String[] args) {
		//{"user_token":"5dc38bc9532bbbe3814e7ef30da1c28f","md5_salt":"d9c123b43304456195490e85599d7a35","balance":30087}
		//device_model=1&password=test&platform=123&platform_flag=555&user_id=testfb2356ddf5scc5d4d2s9e@2scwu7io2c
//		System.out.println(string2MD5("ab=12&ac=23&c=5&cv=125&password=1&userId=test123456"));
//		System.out.println(string2MD5("device_model=1&password=test&platform=123&platform_flag=555&user_id=testfb2356ddf5scc5d4d2s9e@2scwu7io2c",null));
//		System.out.println(string2MD5("platform=2&user_token=5dc38bc9532bbbe3814e7ef30da1c28fd9c123b43304456195490e85599d7a35",null));
	
//		System.out.println(string2MD5("password=123&platform=1&user_id=20fb2356ddf5scc5d4d2s9e@2scwu7io2c",null));
//		AppVersionEntity appVersionEntity = new AppVersionEntity("11", "22");
//		System.out.println(string2MD5("a123456"));

//		String time = "来源：24体育     03-24 14:11";
//		time = time.substring(time.length() - 5);
//
//		System.out.println(string2MD5("123456"));

		String picUrl = "/live/861b303a335a48729df3a367debe10ed-screenshot-19-50-14-1280x720.jpg";
		System.out.println(picUrl.replace("/live/", ""));
	}

}
