package com.live.console.controller;

import com.live.common.domain.ResponseData;
import com.live.common.domain.dto.back.TeamBackResponse;
import com.live.common.domain.request.CommonPage;
import com.live.common.service.MatchService;
import com.live.common.service.TeamService;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

@CrossOrigin
@RestController
@RequestMapping("/team")
@Api(tags = "比赛队伍接口")
public class TeamController {

    @Resource
    private TeamService teamService;

    @PostMapping(value = "/getTeamList")
    @ApiOperation(value = "比赛队伍列表")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> getTeamList(@RequestBody CommonPage commonPage, HttpServletRequest request) {
        return teamService.getTeamList(commonPage, request);
    }

    @PostMapping(value = "/editTeam")
    @ApiOperation(value = "修改队伍 新增时ID null")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> editTeam(@RequestBody TeamBackResponse teamBackResponse, HttpServletRequest request) {
        return teamService.editTeam(teamBackResponse, request);
    }

}