package com.live.common.domain.dto.api;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class MatchInfoNewResponse {

    @ApiModelProperty("竞赛状态 1 正在进行 2未开始 3完场")
    private int status;
    private String matchDay;
    private String matchTime;
    private Integer sportType;
    @ApiModelProperty("主队客队信息")
    private TeamMatchInfo teamMatchInfo;

    @ApiModelProperty("主队比分数据")
    private TeamCompetitionInfo homeCompetition;

    @ApiModelProperty("主队队员比分数据")
    private List<PlayerCompetitionInfo> homePlayerList;

    @ApiModelProperty("客队比分数据")
    private TeamCompetitionInfo awayCompetition;

    @ApiModelProperty("客队队员比分数据")
    private List<PlayerCompetitionInfo> awayPlayerList;

    //一手情报
    private MatchInfoFootballResponse.MatchTeamMsg matchTeamMsg;

    //积分榜
    private MatchInfoFootballResponse.TeamIntegralDto teamIntegralDto;

    //分析数据
    private List<MatchInfoFootballResponse.MatchRecentDto> matchRecentDtos;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class TeamMatchInfo {
        private String matchShortName;

        private MatchListInfo awayTeam;

        private MatchListInfo homeTeam;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class PlayerCompetitionInfo {
        private String playerName;
        private Integer playingTime;
        //首发 0 是 1不是
        private Integer isFirst;
        //总得分
        private Integer score;
        //投篮
        private Integer shots;
        //投篮命中
        private Integer shootNum;
        //俩分
        private Integer twoScore;
        //三分
        private Integer threeShots;
        //三分命中
        private Integer threeShotNum;
        //罚球
        private Integer freeThrows;
        //罚球命中
        private Integer freeThrowNum;
        //助攻
        private Integer assists;
        //助攻篮板
        private Integer attackBoard;
        //防守篮板
        private Integer defensiveBoard;
        //抢断
        private Integer steals;
        //失误
        private Integer error;
        //盖帽
        private Integer blocks;
        //犯规
        private Integer foul;
        //篮板
        private Integer totalBoards;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class TeamCompetitionInfo {

        //总分/一/二/三/四/OT
        private String scoreSettle;
        //0主场1客场
        private String homeOrAway;
        //0胜1负
        private String result;
        //总得分
        private Integer score;
        //投篮
        private Integer shots;
        //投篮命中
        private Integer shootNum;
        //俩分
        private Integer twoScore;
        //三分
        private Integer threeShots;
        //三分命中
        private Integer threeShotNum;
        //罚球
        private Integer freeThrows;
        //罚球命中
        private Integer freeThrowNum;
        //助攻
        private Integer assists;
        //助攻篮板
        private Integer attackBoard;
        //防守篮板
        private Integer defensiveBoard;
        //抢断
        private Integer steals;
        //失误
        private Integer error;
        //盖帽
        private Integer blocks;
        //犯规
        private Integer foul;
        //篮板
        private Integer totalBoards;

    }

}
