package com.live.common.domain.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;
import org.joda.time.DateTime;

import java.util.Date;

/**
 * 主播绑定赛事
 */
@EqualsAndHashCode(callSuper = true)
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@TableName("t_room_host_record")
public class RoomHostRecord extends BaseEntity {

    /**
     * 房间 ID
     */
    private String roomId;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * '赛事ID'
     */
    private String matchId;

    /**
     * '结束时间'
     */
    private Date endTime;

    private Date matchTime;

    /**
     * '主播ID'
     */
    private String hostUserId;

    /**
     * '开播收到的金币'
     */
    private Integer receivedGold;

}
