package com.live.common.service.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.live.common.constant.ConstantValue;
import com.live.common.domain.ResponseData;
import com.live.common.domain.ResultPage;
import com.live.common.domain.dto.back.AdvertListResponse;
import com.live.common.domain.entity.Advert;
import com.live.common.domain.request.CommonPage;
import com.live.common.domain.request.back.AdvertInfoRequest;
import com.live.common.mapper.AdvertMapper;
import com.live.common.service.AdvertisingService;
import com.live.common.utils.DateUtil;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class AdvertisingServiceImpl implements AdvertisingService {

    @Resource
    private AdvertMapper advertMapper;

    @Override
    public ResponseData<?> getAdList(CommonPage commonPage, HttpServletRequest request) {
        int jumpNum = (commonPage.getPageNum() - 1) * commonPage.getPageSize();

        long count = advertMapper.selectCount(Wrappers.<Advert>lambdaQuery()
                .eq(Advert::getDeleted, 0)
        );

        List<Advert> adverts = advertMapper.selectList(Wrappers.<Advert>lambdaQuery()
                .eq(Advert::getDeleted, 0)
                .orderByDesc(Advert::getUpdateTime)
                .last(String.format(" limit %s,%s", jumpNum, commonPage.getPageSize()))
        );

        List<AdvertListResponse> responses = adverts.stream().map(ad -> AdvertListResponse.builder()
                .adDesc(ad.getAdDesc())
                .adTitle(ad.getAdTitle())
                .adType(ad.getAdType())
                .adUrl(ad.getAdUrl())
                .channel(ad.getChannel())
                .createBy(ad.getCreateBy())
                .createTime(DateUtil.format(ad.getCreateTime(), DateUtil.YMDHMS_))
                .id(ad.getId())
                .picPath(ConstantValue.completeAddress(ad.getPicPath()))
                .updateTime(DateUtil.format(ad.getUpdateTime(), DateUtil.YMDHMS_))
                .deleted(ad.getDeleted())
                .build()).collect(Collectors.toList());
        return ResponseData.successResponse(new ResultPage<>(commonPage.getPageNum(), commonPage.getPageSize(), (int) count, responses));
    }

    @Override
    public ResponseData<?> addAdInfo(AdvertInfoRequest advertInfoRequest) {
        advertMapper.insert(Advert.builder()
                .adDesc(advertInfoRequest.getAdDesc())
                .adTitle(advertInfoRequest.getAdTitle())
                .adType(advertInfoRequest.getAdType())
                .adUrl(advertInfoRequest.getAdUrl())
                .picPath(advertInfoRequest.getPicPath())
                .build());
        return ResponseData.successResponse();
    }

    @Override
    public ResponseData<?> editAdInfo(AdvertInfoRequest advertInfoRequest) {
        Advert advert = advertMapper.selectById(advertInfoRequest.getId());
        if(advert == null){
            return ResponseData.fail400Response("未找到广告");
        }
        if(StringUtils.isNotBlank(advertInfoRequest.getAdDesc())){
            advert.setAdDesc(advertInfoRequest.getAdDesc());
        }
        if(StringUtils.isNotBlank(advertInfoRequest.getAdTitle())){
            advert.setAdTitle(advertInfoRequest.getAdTitle());
        }
        if(advertInfoRequest.getAdType() != null){
            advert.setAdType(advertInfoRequest.getAdType());
        }
        if(StringUtils.isNotBlank(advertInfoRequest.getAdUrl())){
            advert.setAdUrl(advertInfoRequest.getAdUrl());
        }
        if(StringUtils.isNotBlank(advertInfoRequest.getPicPath())){
            advert.setPicPath(advertInfoRequest.getPicPath());
        }
        if(advertInfoRequest.getDeleted() != 0){
            advert.setDeleted(advertInfoRequest.getDeleted());
        }

        advertMapper.updateById(advert);
        return ResponseData.successResponse();
    }

}
