package com.live.common.utils;

import com.live.common.domain.entity.User;
import org.apache.commons.lang3.StringUtils;

import javax.servlet.http.HttpServletRequest;

public class CommonMethod {

    public static String getUserPhone(HttpServletRequest request) {
        String token = request.getHeader("token");
        if(StringUtils.isBlank(token)){
            throw new RuntimeException();
        }
        return JWTUtils.getAccount(token).getPhone();
    }

    public static User getUser(HttpServletRequest request) {
        String token = request.getHeader("token");
        return JWTUtils.getAccount(token);
    }

    public static String getDeviceId(HttpServletRequest request) {
        String deviceId = request.getHeader("device-id");
        if(StringUtils.isBlank(deviceId)){
            throw new RuntimeException();
        }
        return deviceId;
    }

//    protected String getUserId(HttpServletRequest request) {
//        String token = request.getHeader("token");
//        return JWTUtils.getAccount(token).getAgentCode();
//    }

    public static  Integer convertCategory(Integer type){
        switch (type){
            //足球
            case 0:
                return 2;
                //篮球
            case 1:
                return 3;
                //其它
            default:
                return 4;
        }
    }

}
