package com.live.console.controller;

import com.live.common.domain.ResponseData;
import com.live.common.domain.request.CommonPage;
import com.live.common.domain.request.back.ArticleListRequest;
import com.live.common.domain.request.back.EditArticleInfoRequest;
import com.live.common.domain.request.back.HotRankListRequest;
import com.live.common.service.ArticleService;
import io.swagger.annotations.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

@Slf4j
@CrossOrigin
@RestController
@RequestMapping("/articleBack")
@Api(tags = "赛事资讯 API 文档")
public class MatchNewsController {

    @Resource
    private ArticleService articleService;

    @PostMapping(value = "/getArticleList")
    @ApiOperation(value = "获取赛事资讯列表")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> getArticleList(@RequestBody ArticleListRequest articleListRequest, HttpServletRequest request){
        return articleService.getArticleList(articleListRequest, request);
    }

    @PostMapping(value = "/editArticleInfo")
    @ApiOperation(value = "修改 / 新增id null 赛事资讯")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> editArticleInfo(@RequestBody EditArticleInfoRequest articleListRequest, HttpServletRequest request){
        return articleService.editArticleInfo(articleListRequest, request);
    }

    @PostMapping(value = "/getArticleTagList")
    @ApiOperation(value = "获取赛事资讯标签列表")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> getArticleTagList(@RequestBody CommonPage commonPage, HttpServletRequest request){
        return articleService.getArticleTagList(commonPage, request);
    }

}
