package com.live.job.entity.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class AlStatBasketballLeagueRankDto {

    private String state;
    private List<Standing> standing;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class Standing {
        private Integer seasonId;
        private String season;
        private List<Stages> stages;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class Stages {
        private Integer stageId;
        private String stageName;
        private List<Group> groups;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class Group {
        private Integer groupId;
        private String groupName;
        private List<StandingInfo> standings;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class StandingInfo {
        private Integer id;
        private Integer teamId;
        private String teamName;
        private String type;
        private Integer matches;
        private Integer wins;
        private Integer losts;
        private Integer pointsFor;
        private Integer pointsAga;
        private Integer pointsDiff;
        private Integer position;
        private String qualificate;
        private String form;

//        “id”: 629,				//积分榜数据Id
//                “teamId”: 1,			//球队Id
//                “type”: “total”,		//积分榜类型（total: 总积分榜, home: 主场积分榜, away: 客场积分榜）
//                “matches”: 38,			//比赛场次
//                “wins”: 26,				//获胜场次
//                “losts”: 3,				//失利场次
//                “pointsFor”: 73,		//总得分
//                “pointsAga”: 32,		//总失分
//                “pointsDiff”: 41,		//净胜分
//                “form”: “WWLDWL”		//最近6场战绩
    }
}
