package com.live.server.controller;

import com.live.common.domain.ResponseData;
import com.live.common.domain.request.*;
import com.live.common.service.ArticleService;
import com.live.common.service.CategoryService;
import com.live.common.service.MatchService;
import io.swagger.annotations.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

@Slf4j
@CrossOrigin
@RestController
@RequestMapping("/find")
@Api(tags = "发现界面 API 文档")
public class FindController {

    @Resource
    private MatchService matchService;
    @Resource
    private ArticleService articleService;
    @Resource
    private CategoryService categoryService;

    @PostMapping(value = "/customMadeTeam")
    @ApiOperation(value = "获取定制球队 -1 全部 0 足球 1 篮球")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> customMadeTeam(@RequestBody CommonIntId commonIntId, HttpServletRequest request) {
        return categoryService.customMadeTeam(commonIntId, request);
    }

    @PostMapping(value = "/userCustomMadeTeam")
    @ApiOperation(value = "用户设置定制 球队 id")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> userCustomMadeTeam(@RequestBody UserMsgRequest userMsgRequest, HttpServletRequest request) {
        return matchService.userCustomMadeTeam(userMsgRequest, request);
    }

    @PostMapping(value = "/getUserCustomMadeTeam")
    @ApiOperation(value = "获取用户定制的球队")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> getUserCustomMadeTeam(HttpServletRequest request) {
        return matchService.getUserCustomMadeTeam(request);
    }

    @PostMapping(value = "/getMatchListByTeamId")
    @ApiOperation(value = "根据用户定制的球队id 获取【近期比赛】")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> getMatchListByTeamId(@RequestBody CommonStringId commonStringId, HttpServletRequest request) {
        return matchService.getMatchListByTeamId(commonStringId, request);
    }

    @PostMapping(value = "/getArticleListByTeamId")
    @ApiOperation(value = "根据用户定制的球队id 获取【相关资讯】")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> getArticleListByTeamId(@RequestBody GetArticleListByTeamIdRequest commonPage, HttpServletRequest request) {
        return articleService.getArticleListByTeamId(commonPage, request);
    }

}
