package com.live.common.domain.dto.api;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class PlayerInfoFootballResponse {

    private Integer id;

    private String name;
    private String nameEn;
    private String country;
    private String birthday;
    @ApiModelProperty("球衣号码")
    private String rnNumber;
    @ApiModelProperty("身高")
    private String height;
    @ApiModelProperty("体重")
    private String weight;
    @ApiModelProperty("位置")
    private String position;
    @ApiModelProperty("惯用脚（left左脚,right右脚,both左右脚）")
    private String foot;
    @ApiModelProperty("主要位置")
    private String mainPosition;
    @ApiModelProperty("次要位置")
    private String secondPosition1;
    @ApiModelProperty("次要位置")
    private String secondPosition2;
    @ApiModelProperty("身价 欧元")
    private Integer marketValue;
    @ApiModelProperty("国家队进球数")
    private Integer nationalGoals;
    @ApiModelProperty("国家队入选次数")
    private Integer nationalChosenTimes;
    private String icon;

}
