package com.live.common.service;

import com.live.common.domain.ResponseData;
import com.live.common.domain.request.*;
import com.live.common.domain.request.back.ArticleListRequest;
import com.live.common.domain.request.back.EditArticleInfoRequest;
import org.springframework.web.bind.annotation.RequestBody;

import javax.servlet.http.HttpServletRequest;

public interface ArticleService {

    ResponseData<?> getArticleTopTagList();

    ResponseData<?> getArticleType();

    ResponseData<?> getTopArticleList(HttpServletRequest request);

    ResponseData<?> getArticleListByTagId(ArticleByTagIdRequest tagIdRequest, HttpServletRequest request);

    ResponseData<?> getArticleInfoById(CommonStringId commonStringId, HttpServletRequest request);

    ResponseData<?> likeArticle(CommonIntId commonIntId, HttpServletRequest request);

    ResponseData<?> getArticleListByTitleLike(ArticleByTitleLikeRequest titleLikeRequest, HttpServletRequest request);

    // back

    ResponseData<?> getArticleList(ArticleListRequest articleListRequest, HttpServletRequest request);

    ResponseData<?> editArticleInfo(EditArticleInfoRequest editArticleInfo, HttpServletRequest request);

    ResponseData<?> getArticleTagList(CommonPage commonPage, HttpServletRequest request);
}
