package com.live.console.controller;

import com.live.common.domain.ResponseData;
import com.live.common.domain.request.CommonPage;
import com.live.common.domain.request.back.AdvertInfoRequest;
import com.live.common.service.AdvertisingService;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

@CrossOrigin
@RestController
@RequestMapping("/ad")
@Api(tags = "广告接口")
public class AdvertisingController {

    @Resource
    private AdvertisingService advertisingService;

    @PostMapping(value = "/getAdList")
    @ApiOperation(value = "广告列表")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> getAdList(@RequestBody CommonPage commonPage, HttpServletRequest request) {
        return advertisingService.getAdList(commonPage, request);
    }

    @PostMapping(value = "/addAdInfo")
    @ApiOperation(value = "新增广告")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> addAdInfo(@RequestBody AdvertInfoRequest advertInfoRequest, HttpServletRequest request) {
        return advertisingService.addAdInfo(advertInfoRequest);
    }

    @PostMapping(value = "/editAdInfo")
    @ApiOperation(value = "修改广告")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> editAdInfo(@RequestBody AdvertInfoRequest advertInfoRequest, HttpServletRequest request) {
        return advertisingService.editAdInfo(advertInfoRequest);
    }

}
