package com.live.job.entity.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class TeamReportDto {

    private ModelData modeData;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class ModelData {
        private List<ReportDto> listData;

        private int playStatus;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class ReportDto {
        private String SectionName;
        //1 一手情报 2 积分榜 3 分析数据
        private int SectionType;
        private List<String> leagueMatchHeader;
        private List<LeagueMatch> leagueMatchList;

    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class LeagueMatch {
        private String teamId;
        private String teamName;
        //一手情报
        private List<TeamInformation> teamInformation;
        //积分榜
        private List<List<String>> leagueMatchData;
        //分析数据
        private List<List<String>> CompetitionData;

        private String teamRecordLost;
        private String teamRecordName;
        private String teamRecordTie;
        private String teamRecordWin;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class TeamInformation {
        private String intelligenceName;
        private List<Text> intelligenceArr;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class Text {
        private String text;
    }

}
