package com.live.server.controller;

import com.live.common.domain.ResponseData;
import com.live.common.domain.request.CommonIntId;
import com.live.common.domain.request.CommonPage;
import com.live.common.service.MatchService;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.*;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

@CrossOrigin
@RestController
@RequestMapping("/data")
@Api(tags = "赛事/球队 数据接口")
public class MatchDataController {

    @Resource
    private MatchService matchService;

    @PostMapping(value = "/getMatchTypeInfoAllList")
    @ApiOperation(value = "获取 全部 赛事类别详情")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    public ResponseData<?> getMatchTypeInfoList(HttpServletRequest request) {
        return matchService.getMatchTypeInfoList(request);
    }

    @PostMapping(value = "/getTeamInfoList")
    @ApiOperation(value = "获取 所有 球队列表")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    public ResponseData<?> getTeamInfoList(HttpServletRequest request) {
        return matchService.getTeamInfoList(request);
    }

    @PostMapping(value = "/getPlayerList")
    @ApiOperation(value = "获取球员列表 其他球员分页")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    public ResponseData<?> getPlayerList(@RequestBody CommonPage commonPage, HttpServletRequest request) {
        return matchService.getPlayerList(commonPage, request);
    }

    @PostMapping(value = "/getPlayerInfoBasketballById")
    @ApiOperation(value = "获取球员详情 篮球 sportsId=1")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    public ResponseData<?> getPlayerInfoBasketballById(@RequestBody CommonIntId commonIntId, HttpServletRequest request) {
        return matchService.getPlayerInfoBasketballById(commonIntId, request);
    }

    @PostMapping(value = "/getPlayerInfoFootballById")
    @ApiOperation(value = "获取球员详情 足球 sportsId=0")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    public ResponseData<?> getPlayerInfoFootballById(@RequestBody CommonIntId commonIntId, HttpServletRequest request) {
        return matchService.getPlayerInfoFootballById(commonIntId, request);
    }

}