package com.live.common.domain.request;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class SendMessageByRoomRequest {

    //发送的目标类型；users：给用户发消息，chatgroups：给群发消息，chatrooms：给聊天室发消息
    private String target_type;
    //发送的目标；注意这里需要用数组，数组内添加的最大用户数默认600个，即使只有一个用户，也要用数组 ['u1']；
    //给用户发送时数组元素是用户名，给群组发送时，数组元素是groupid
    private List<String> target;

    private SendMessage msg;
    //表示消息发送者;无此字段Server会默认设置为“from”:“admin”，有from字段但值为空串(“”)时请求失败
    private String from;
    //扩展属性，由APP自己定义。JSON 格式，可以没有这个字段，但是如果有，值不能是“ext:null”这种形式，否则出错
    private Ext ext;

    @Data
    @Builder
    @AllArgsConstructor
    @NoArgsConstructor
    public static class SendMessage {
        //消息类型；txt:文本消息，img：图片消息，loc：位置消息，audio：语音消息，video：视频消息，file：文件消息
        private String type;
        private String msg;
    }

    @Data
    @Builder
    @AllArgsConstructor
    @NoArgsConstructor
    public static class Ext {
        private String user_nick;
        private Integer user_level;
        private String live_room_user_name;
    }

}
