package com.live.common.service.impl;

import com.live.common.domain.ResponseData;
import com.live.common.domain.dto.back.SysMenuDTO;
import com.live.common.domain.entity.SysMenu;
import com.live.common.domain.request.back.SysMenuVO;
import com.live.common.mapper.SysMenuMapper;
import com.live.common.mapper.SysRoleMapper;
import com.live.common.service.ISysMenuService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @Author: bob
 * @Date: 2020/6/15 19:19
 * @Version 1.0
 */
@Service
@Transactional
@Slf4j
public class SysMenuServiceImpl implements ISysMenuService {

    @Resource
    private SysMenuMapper sysMenuMapper;

    @Resource
    private SysRoleMapper sysRoleMapper;

    @Override
    public ResponseData<?> save(SysMenuDTO sysMenu) {
        sysMenuMapper.insert(Converter(sysMenu));
        return ResponseData.successResponse();
    }

    @Override
    public ResponseData<?> update(SysMenuDTO sysMenuDTO) {
        sysMenuMapper.updateById(Converter(sysMenuDTO));
        return ResponseData.successResponse();
    }

    private SysMenu Converter(SysMenuDTO sysMenu){
        return SysMenu.builder()
                .id(sysMenu.getId())
                .createTime(new Date())
                .deleted(sysMenu.getDeleted())
                .jumpPath(sysMenu.getJumpPath())
                .menuDes(sysMenu.getMenuDes())
                .name(sysMenu.getName())
                .path(sysMenu.getPath())
                .sort(sysMenu.getSort())
                .type(sysMenu.getType())
                .build();
    }

    @Override
    public ResponseData<?> getSysMenuList() {
//        int jumpNum = (commonPageNum.getPageNum() - 1) * commonPageNum.getPageSize();
        List<SysMenuVO> sysMenuDTOS = sysMenuMapper.getMenus();
        return ResponseData.successResponse(sysMenuDTOS);
    }

    @Override
    public ResponseData<?> getSysMenuDTO(Integer menuId) {
        SysMenu sysMenu = sysMenuMapper.selectById(menuId);
        return ResponseData.successResponse(SysMenuDTO.builder()
                .id(sysMenu.getId())
                .deleted(sysMenu.getDeleted())
                .jumpPath(sysMenu.getJumpPath())
                .menuDes(sysMenu.getMenuDes())
                .name(sysMenu.getName())
                .path(sysMenu.getPath())
                .sort(sysMenu.getSort())
                .type(sysMenu.getType())
                .build());
    }

    @Override
    public ResponseData<?> getSysMenuDTOS(Integer id) {
        List<String> strs = new ArrayList<>();
        String menuId = sysRoleMapper.getSysRoleMenu(id).get(0).getMenuId();

        String[] menus = menuId.split(",");
        for (int i = 0; i < menus.length; i++) {
            ResponseData responseData = this.getSysMenuDTO(Integer.valueOf(menus[i]));
            SysMenuDTO sysMenuDTO = (SysMenuDTO) responseData.getData();
            if (sysMenuDTO.getPath() != null) {
                String[] strings = sysMenuDTO.getPath().split(",");
                for (int j = 0; j < strings.length; j++) {
                    strs.add(strings[j]);
                }
            }
        }

        return ResponseData.successResponse(strs);
    }


}
