package com.live.job.entity.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class CrawlIndexCompanyBasketballDto {

    private String state;

    private List<CrawlIndexCompanyBasketballInfoDto> mainOdds;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class CrawlIndexCompanyBasketballInfoDto {
        private Integer matchId;
        private String startTime;
        //主队名称
        private String homeTeamName;
        //客队名称
        private String awayTeamName;

        private List<IndexBasketballInfoOuZhiOddsDto> ouzhiOdds;
        //让分
        private List<IndexBasketballInfoYaZhiOddsDto> rfOdds;
        private List<IndexBasketballInfoDaXiaoOddsDto> daxiaoOdds;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class IndexBasketballInfoOuZhiOddsDto {
        //公司ID
        private Integer companyId;
        //类型（0: 初盘, 1: 即时盘）
        private Integer type;
        //主胜赔率
        private Double win;
        //客胜赔率
        private Double loss;
        //变盘时间
        private String changeTime;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class IndexBasketballInfoYaZhiOddsDto {
        //公司ID
        private Integer companyId;
        //类型（0: 初盘, 1: 即时盘）
        private Integer type;
        //让球
        private Double handicap;
        //主队赔率
        private Double home;
        //客胜赔率
        private Double away;
        //变盘时间
        private String changeTime;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class IndexBasketballInfoDaXiaoOddsDto {
        //公司ID
        private Integer companyId;
        //类型（0: 初盘, 1: 即时盘）
        private Integer type;
        //盘口
        private Double handicap;
        //大球赔率
        private Double over;
        //小球赔率
        private Double under;
        //变盘时间
        private String changeTime;
    }
}
