package com.live.job.entity.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class TeamCompetitionDto {

    private String content;

    private GameInfo gameInfo;

    private List<GameState> gameStat;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class GameInfo {
        //主队
        private String AScore;
        //客队
        private String BScore;
        private String HomeTeamShortName;
        private String AwayTeamShortName;
        private Integer Status;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class GameState {
        private Integer PlayerID;
        private String TeamID;
        //1 缺席 不是首发 0 没有缺席 是首发
        private String AbsentReason;
        private String PlayerName;
        //参与比赛时间
        private Integer PlayingTime;

        private Integer assists;
        private Integer AttackBoard;
        private Integer Blocks;
        private Integer DefensiveBoard;
        private Integer Error;
        private Integer Foul;
        private Integer FreeThrowNum;
        private Integer FreeThrows;
        private String HomeOrAway;
        private String Result;
        private Integer Score;
        private Integer ShootNum;
        private Integer ShootScore;
        private Integer Shots;
        private Integer SlamDunk;
        private Integer Steals;
        private Integer ThreeShotNum;
        private Integer ThreeShots;
        private Integer ThreeShotsScore;
        private Integer TotalBoards;
        private Integer TwoScore;
    }

}
