package com.live.common.domain.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

@EqualsAndHashCode(callSuper = true)
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@TableName("t_football_league_rank")
public class FootballLeagueRank extends BaseEntity {

    private String season;
    private String teamId;
    private String sportsId;
    //分组名
    private String groupName;
    //比赛场次
    private Integer matches;
    //赢
    private Integer wins;
    //平局
    private Integer draws;
    //失利
    private Integer losts;
    //进球
    private Integer goalFor;
    //失球
    private Integer goalAga;
    //净胜
    private Integer goalDiff;
    //积分
    private Integer points;
    //排名
    private Integer position;
    //入围
    private String qualificate;

}
