package com.live.job.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@Component
public class CrawlStrategyFactory {

    @Autowired
    private Set<CrawlMatchService> crawlMatchServiceSet;
    @Autowired
    private Set<CrawlAnchorService> crawlAnchorServices;

    private final Map<String, CrawlMatchService> crawMatchServiceMap = new ConcurrentHashMap<>();
    private final Map<String, CrawlAnchorService> crawlAnchorServiceMap = new ConcurrentHashMap<>();

    public CrawlMatchService getCrawMatchService(String component) {
        CrawlMatchService matchService = crawMatchServiceMap.get(component);
        if (matchService == null) {
            throw new RuntimeException("没找到对应实现类");
        }
        return matchService;
    }

    public CrawlAnchorService getCrawlAnchorService(String component) {
        CrawlAnchorService matchService = crawlAnchorServiceMap.get(component);
        if (matchService == null) {
            throw new RuntimeException("没找到对应实现类");
        }
        return matchService;
    }

    @PostConstruct
    public void init() {
        for (CrawlMatchService crawlMatchService : crawlMatchServiceSet) {
            crawMatchServiceMap.put(crawlMatchService.getPlatform(), crawlMatchService);
        }

        for (CrawlAnchorService crawlAnchorService : crawlAnchorServices) {
            crawlAnchorServiceMap.put(crawlAnchorService.getPlatform(), crawlAnchorService);
        }
    }
}