package com.live.common.domain.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import java.util.Date;

@EqualsAndHashCode(callSuper = true)
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@TableName("t_article")
public class Article extends BaseEntity {

    private String title;

    private String picUrl;

    private int hot;

    //0 不是热点文章 1 是
    private int hotNews;

    private int showHome;

    private String authorId;

    private Date releaseTime;

    private String authorName;

    //0文章1视频连接
    private int contentType;

    private String content;

    private String link;

    private int readNum;

    private int shareNum;

    private String tagId;

    private int fakeLike;

}
