package com.live.common.domain.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import java.util.Date;

@TableName("t_room")
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
public class Room {

    //环信房间ID
    @TableId(value = "huan_xin_room_id")
    private String huanXinRoomId;

    private String roomName;

    private String roomDesc;

    //唯一房间号
    private String roomNum;

    //是否正在直播 0 不在 1 在
    private Integer type;

    //category id
    private Integer categoryId;

    private String matchId;

    //主播ID
    private String userId;

    private String announcement;
    //房间封面
    private String roomCover;

    private Integer likeNum;

    private Integer hotNum;

    //0 不属于热门直播 1属于
    private Integer showHot;

    //0不推荐 1推荐
    private Integer recommend;

    private String liveUrl;

    //是否展示在首页 0不展示 1展示
    private Integer showHome;

    //是否使用截图 0不适用 1使用
    private Integer useCutImg;

    private String qqNum;

    private String qqGroupNum;

    private String wxNum;

    private String lastUpMd5;

    //0 己方 1红杉 2UU球
    private Integer source;

    //0禁用，1启用聊天假消息
    private Integer enableFakeChat;

    /**
     * 创建人
     */
    private String  createBy;
    /**
     * '创建时间'
     */
    private Date createTime;
    /**
     * '更新时间'
     */
    @TableField(value="update_time")
    private Date updateTime;
    /**
     * '是否删除' 默认0未删除
     */
    private Integer  deleted;

}
