package com.live.common.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.live.common.domain.ResponseData;
import com.live.common.domain.dto.back.SysMenuDTO;
import com.live.common.domain.dto.back.SysRoleDTO;
import com.live.common.domain.entity.SysRole;
import com.live.common.domain.request.back.RoleVO;
import com.live.common.domain.request.back.RolesVO;
import com.live.common.mapper.SysRoleMapper;
import com.live.common.service.ISysMenuService;
import com.live.common.service.ISysRoleService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import java.util.*;

@Service
@Transactional
@Slf4j
public class SysRoleServiceImpl implements ISysRoleService {

    @Resource
    private SysRoleMapper sysRoleMapper;

    @Resource
    private ISysMenuService iSysMenuService;

    @Override
    public ResponseData<?> save(RoleVO sysRoleDTO) {
        SysRole sysRole = new SysRole();
        sysRole.setRoleName(sysRoleDTO.getRoleName());
        sysRole.setRoleDesc(sysRoleDTO.getRoleDesc());
        if (com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull(sysRoleDTO.getMenus())) {
            Set<Map.Entry<String, String>> entries = sysRoleDTO.getMenus().entrySet();
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : entries) {
                if (sb.length() > 0) {//该步即不会第一位有逗号，也防止最后一位拼接逗号！
                    sb.append(",");
                }
                sb.append(entry.getKey());
            }
            sysRole.setMenuId(sb.toString());
        }
        sysRoleMapper.insert(sysRole);
        return ResponseData.successResponse();
    }

    @Override
    public ResponseData<?> update(SysRoleDTO sysRoleDTO) {
        SysRole sysRole = sysRoleConvert(sysRoleDTO);
        sysRole.setId(sysRoleDTO.getId());
        if (com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull(sysRoleDTO.getMenus())) {
            Set<Map.Entry<String, String>> entries = sysRoleDTO.getMenus().entrySet();
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : entries) {
                if (sb.length() > 0) {//该步即不会第一位有逗号，也防止最后一位拼接逗号！
                    sb.append(",");
                }
                sb.append(entry.getKey());
            }
            sysRole.setMenuId(sb.toString());
        }

        sysRoleMapper.updateById(sysRole);
        return ResponseData.successResponse();
    }

    private SysRole sysRoleConvert(SysRoleDTO sysRoleDTO) {
        return SysRole.builder()
                .deleted(sysRoleDTO.getDeleted())
                .menuId(sysRoleDTO.getMenuId())
                .roleCode(sysRoleDTO.getRoleCode())
                .roleDesc(sysRoleDTO.getRoleDesc())
                .roleName(sysRoleDTO.getRoleName())
                .build();
    }

    @Override
    public ResponseData<?> getSysRoleList() {
        List<RolesVO> rolesVOPage = sysRoleMapper.getRoleVOs();

        for (RolesVO sysRoleDTO : rolesVOPage) {
            if (!ObjectUtils.isEmpty(sysRoleDTO.getMenuId()) && sysRoleDTO.getMenuId().contains(",")) {
                Map<String, String> menus = new HashMap<>();
                String[] menuIds = sysRoleDTO.getMenuId().split(",");
                for (int i = 0; i < menuIds.length; i++) {
                    ResponseData responseData = iSysMenuService.getSysMenuDTO(Integer.valueOf(menuIds[i]));
                    SysMenuDTO sysMenuDTO = (SysMenuDTO) responseData.getData();
                    menus.put(menuIds[i], sysMenuDTO.getName());
                }
                sysRoleDTO.setMenus(menus);
            } else if (!ObjectUtils.isEmpty(sysRoleDTO.getMenuId()) && !sysRoleDTO.getMenuId().contains(",")) {
                Map<String, String> menuMap = new HashMap<>();
                ResponseData responseData = iSysMenuService.getSysMenuDTO(Integer.valueOf(sysRoleDTO.getMenuId()));
                SysMenuDTO sysMenuDTO = (SysMenuDTO) responseData.getData();
                menuMap.put(sysRoleDTO.getMenuId(), sysMenuDTO.getName());
                sysRoleDTO.setMenus(menuMap);
            }
        }
        return ResponseData.successResponse(rolesVOPage);
    }

    @Override
    public ResponseData<?> getSysRoleMenu(Integer id) {
        QueryWrapper<SysRole> wrapper = new QueryWrapper<>();
        wrapper.eq("role_id", id);
        List<SysRoleDTO> roleMenu = sysRoleMapper.getRoleMenu(id);
        return ResponseData.successResponse(roleMenu);
    }

    @Override
    public ResponseData<?> getSysRoleDetail(Integer roleId) {
        SysRole sysRole = sysRoleMapper.selectById(roleId);
        RoleVO roleVO = new RoleVO();
        roleVO.setId(sysRole.getId());
        roleVO.setDeleted(sysRole.getDeleted());
        // roleVO.setMenuId(sysRole.getMenuId());
        roleVO.setRoleName(sysRole.getRoleName());
        roleVO.setRoleDesc(sysRole.getRoleDesc());
        if (sysRole.getMenuId() != null && sysRole.getMenuId().contains(",")) {
            List<String> menuList = new ArrayList<>();
            Map<String, String> menuMap = new HashMap<>();
            String[] menuIds = sysRole.getMenuId().split(",");
            for (int i = 0; i < menuIds.length; i++) {
                ResponseData responseData = iSysMenuService.getSysMenuDTO(Integer.valueOf(menuIds[i]));
                SysMenuDTO sysMenuDTO = (SysMenuDTO) responseData.getData();
                menuMap.put(menuIds[i], sysMenuDTO.getName());
                //menuList.add(name);
            }
            //roleVO.setMenus(menuList);
            roleVO.setMenus(menuMap);
        } else if (sysRole.getMenuId() != null && !sysRole.getMenuId().contains(",")) {
            //List<String> menus=new ArrayList<>();
            Map<String, String> menus = new HashMap<>();
            ResponseData responseData = iSysMenuService.getSysMenuDTO(Integer.valueOf(sysRole.getMenuId()));
            SysMenuDTO sysMenuDTO = (SysMenuDTO) responseData.getData();
            menus.put(sysRole.getMenuId(), sysMenuDTO.getName());
            roleVO.setMenus(menus);
        }
        return ResponseData.successResponse(roleVO);
    }


}
