package com.live.console.controller;

import com.live.common.domain.ResponseData;
import com.live.common.domain.request.CommonPage;
import com.live.common.domain.request.back.EditRobotMsgRequest;
import com.live.common.domain.request.back.EditRoomRequest;
import com.live.common.domain.request.back.GetRoomListRequest;
import com.live.common.service.RoomService;
import io.swagger.annotations.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

@Slf4j
@CrossOrigin
@RestController
@RequestMapping("/backRoom")
@Api(tags = "直播房间接口 API 文档")
public class RoomConsoleController {

    @Resource
    private RoomService roomService;

    @PostMapping(value = "/getRoomList")
    @ApiOperation(value = "获取房间列表")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> getRoomList(@RequestBody GetRoomListRequest commonPage, HttpServletRequest request) {
        return roomService.getRoomList(commonPage, request);
    }

    @PostMapping(value = "/editRoomById")
    @ApiOperation(value = "修改房间信息")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> editRoomById(@RequestBody EditRoomRequest editRoomRequest, HttpServletRequest request) {
        return roomService.editRoomById(editRoomRequest, request);
    }

    @PostMapping(value = "/getRobotMsgList")
    @ApiOperation(value = "获取机器人假消息列表")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> getRobotMsgList(@RequestBody CommonPage commonPage, HttpServletRequest request) {
        return roomService.getRobotMsgList(commonPage, request);
    }

    @PostMapping(value = "/editRobotMsg")
    @ApiOperation(value = "修改或新增机器人假消息")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> editRobotMsg(@RequestBody EditRobotMsgRequest editRobotMsgRequest, HttpServletRequest request) {
        return roomService.editRobotMsg(editRobotMsgRequest, request);
    }

}
