package com.live.job.entity.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class AlStatSportsBasketballDto {

    private String state;
    private List<AlStatBasketballCompetition> competitions;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class AlStatBasketballCompetition {
        private Integer id;
        private String name;
        private String nameFull;
        private String nameEn;
        private String nameEnFull;
        private String competitionType;
        private String teamType;
        private String currSeason;
        //性别类型（male: 男子, female： 女子, youthMale: 青年男子, youthFemale: 青年女子）
        private String gender;
        //比赛常规时间节数
        private Integer quarterNum;
        //每节比赛时间
        private String quarterTime;
        //当前赛季Id
        private Integer currSeasonId;

//			“id”: 1,						//赛事Id
//                “name”: “美职篮”,				//赛事名称（简称）
//                “nameFull”: “美国职业篮球联赛”,	//赛事名称（全称）
//                “nameEn”: “NBA”,				//赛事英文名称
//                “nameEnFull”: “National Basketball Association”,		//赛事英文名称（全称）
//                “competitionType”: “league”,	//赛事类型（league: 联赛, cup: 杯赛）
//                “teamType”: “club”,				//参加球队的类型（club: 俱乐部, national: 国家队）
//                “gender”: “male”,				//性别类型（male: 男子, female： 女子, youthMale: 青年男子, youthFemale: 青年女子）
//                “currSeason”: “19/20”,			//当前赛季
//                “currSeasonId”: 4,				//当前赛季Id
//                “areaId”: 193,					//赛事举办国家或大洲
//                “quarterNum”: 4,				//比赛常规时间节数
//                “quarterTime”: “12:00”,			//每节比赛时间
//                “colour”: “FF3333”				//色号
    }

}
