package com.live.common.domain.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

@EqualsAndHashCode(callSuper = true)
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@TableName("t_player_competition")
public class PlayerCompetition extends BaseStringIdEntity {

    private String teamId;
    private String teamCompetitionId;
    private String matchId;

    //玩家位置
    private String position;
    private String playerName;
    //参赛时长 / 分钟
    private Integer playingTime;
    //0首发 1否
    private String absentReason;
    //0主场1客场
    private Integer homeOrAway;
    //总得分
    private Integer score;
    //投篮
    private Integer shots;
    //投篮命中
    private Integer shootNum;
    //俩分
    private Integer twoScore;
    //三分
    private Integer threeShots;
    //三分命中
    private Integer threeShotNum;
    //罚球
    private Integer freeThrows;
    //罚球命中
    private Integer freeThrowNum;
    //助攻
    private Integer assists;
    //助攻篮板
    private Integer attackBoard;
    //防守篮板
    private Integer defensiveBoard;
    //抢断
    private Integer steals;
    //失误
    private Integer error;
    //盖帽
    private Integer blocks;
    //犯规
    private Integer foul;
    //篮板
    private Integer totalBoards;
}
