package com.live.common.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.live.common.constant.ConstantValue;
import com.live.common.domain.ResponseData;
import com.live.common.domain.dto.api.*;
import com.live.common.domain.entity.Category;
import com.live.common.domain.entity.Sports;
import com.live.common.domain.entity.Team;
import com.live.common.domain.request.CommonIntId;
import com.live.common.mapper.CategoryMapper;
import com.live.common.mapper.SportsMapper;
import com.live.common.mapper.TeamMapper;
import com.live.common.service.CategoryService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Service
public class CategoryServiceImpl implements CategoryService {

    @Resource
    private TeamMapper teamMapper;
    @Resource
    private SportsMapper sportsMapper;
    @Resource
    private CategoryMapper categoryMapper;

    @Override
    public ResponseData<?> getTitleTab() {
        List<Category> categoryList = categoryMapper.selectList(Wrappers.<Category>lambdaQuery()
                .eq(Category::getDeleted, 0)
                .eq(Category::getCategoryType, 0)
                .orderByDesc(Category::getSortValue)
        );

        return ResponseData.successResponse(categoryList.stream().map(b -> CategoryListResponse.builder()
                .sportsId(b.getSportsId() == null ? "" : b.getSportsId())
                .sort(b.getSortValue())
                .sportsName(b.getSportsName())
                .build()).collect(Collectors.toList()));
    }

    @Override
    public ResponseData<?> getMatchSportsType() {
        List<MatchSportsTypeResponse> responses = new LinkedList<>();
        List<Sports> sports = sportsMapper.selectList(Wrappers.<Sports>lambdaQuery()
                .eq(Sports::getDeleted, 0)
                .eq(Sports::getSourceType, 1)
                .eq(Sports::getShowMatch, 1)
                .orderByDesc(Sports::getSort)
        );

        List<CategoryListResponse> football = new LinkedList<>();
        football.add(CategoryListResponse.builder()
                .sportsId("0")
                .sportsName("全部")
                .sort(0)
                .build());
        football.addAll(sports.stream().filter(b -> b.getSportsId() == 0).map(b -> CategoryListResponse.builder()
                .sportsId(b.getId())
                .sort(b.getSort())
                .sportsName(b.getCompetitionShortName())
                .sportsIcon(b.getCompetitionIcon())
                .build()).collect(Collectors.toList()));

        List<CategoryListResponse> basketball = new LinkedList<>();
        basketball.add(CategoryListResponse.builder()
                .sportsId("1")
                .sportsName("全部")
                .sort(0)
                .build());
        basketball.addAll(sports.stream().filter(b -> b.getSportsId() == 1).map(b -> CategoryListResponse.builder()
                .sportsId(b.getId())
                .sort(b.getSort())
                .sportsName(b.getCompetitionShortName())
                .sportsIcon(b.getCompetitionIcon())
                .build()).collect(Collectors.toList()));

        responses.add(MatchSportsTypeResponse.builder()
                .sportsType("足球")
                .sportsList(football)
                .build());
        responses.add(MatchSportsTypeResponse.builder()
                .sportsType("篮球")
                .sportsList(basketball).build());
        return ResponseData.successResponse(responses);
    }

    //主播开播类型选项 过滤全部
    @Override
    public ResponseData<?> getLiveTitleTab() {
        List<Category> categoryList = categoryMapper.selectList(Wrappers.<Category>lambdaQuery()
                .eq(Category::getDeleted, 0)
                .eq(Category::getCategoryType, 0)
                .orderByDesc(Category::getSortValue)
        );

        return ResponseData.successResponse(categoryList.stream().filter(b -> StringUtils.isNotBlank(b.getSportsId()))
                .map(b -> CategoryListResponse.builder()
                        .sportsId(b.getSportsId())
                        .sort(b.getSortValue())
                        .sportsName(b.getSportsName())
                        .build()).collect(Collectors.toList()));
    }

    @Override
    public ResponseData<?> getMatchHomeType(HttpServletRequest request) {
        List<Sports> sports = sportsMapper.selectList(Wrappers.<Sports>lambdaQuery()
                .eq(Sports::getDeleted, 0)
                .eq(Sports::getSourceType, 1)
                .eq(Sports::getShowMatch, 1)
                .orderByDesc(Sports::getSort)
        );

        List<MatchTypeListResponse> matchTypeListResponses = new LinkedList<>();
        matchTypeListResponses.add(MatchTypeListResponse.builder()
                .sportsId("-1")
                .sportsIcon(null)
                .sportsName("热门")
                .build());

        sports.forEach(b -> matchTypeListResponses.add(MatchTypeListResponse.builder()
                .sportsId(b.getId())
                .sportsIcon(ConstantValue.completeAddress(b.getCompetitionIcon()))
                .sportsName(b.getCompetitionShortName())
                .build()));
        return ResponseData.successResponse(matchTypeListResponses);
    }

    @Override
    public ResponseData<?> customMadeTeam(CommonIntId commonIntId, HttpServletRequest request) {
        if(commonIntId == null || commonIntId.getId() < -1 || commonIntId.getId() > 1){
            return ResponseData.fail400Response(" -1 全部 0 足球 1 篮球");
        }

        QueryWrapper<Sports> wrapper = new QueryWrapper<>();
        wrapper.eq("deleted", 0);
        wrapper.eq("source_type", 1);
        wrapper.eq("custom_made", 1);
        if(commonIntId.getId() != -1){
            wrapper.eq("sports_id", commonIntId.getId());
        }

        List<Sports> sports = sportsMapper.selectList(wrapper);

        CustomMadeTeamResponse response = new CustomMadeTeamResponse();
        response.setBasketball(new LinkedList<>());
        response.setFootball(new LinkedList<>());
        for(Sports s : sports){
            List<Team> teams = teamMapper.selectList(Wrappers.<Team>lambdaQuery()
                    .eq(Team::getDeleted, 0)
                    .eq(Team::getOriginalType, 1)
                    .eq(Team::getSportsDbId, s.getId())
                    .orderByDesc(Team::getUpdateTime)
            );
            if(s.getSportsId() == 0){
                response.getFootball().add(CustomMadeTeamResponse.CustomMadeTeamInfo.builder()
                        .sportsName(s.getCompetitionShortName())
                        .teamResponses(teams.stream().map(b -> TeamResponse.builder()
                                .score(0)
                                .teamName(b.getTeamName())
                                .teamIcon(b.getTeamIcon())
                                .id(b.getId())
                                .build()).collect(Collectors.toList()))
                        .build());
            } else {
                response.getBasketball().add(CustomMadeTeamResponse.CustomMadeTeamInfo.builder()
                        .sportsName(s.getCompetitionShortName())
                        .teamResponses(teams.stream().map(b -> TeamResponse.builder()
                                .score(0)
                                .teamName(b.getTeamName())
                                .teamIcon(b.getTeamIcon())
                                .id(b.getId())
                                .build()).collect(Collectors.toList()))
                        .build());
            }
        }
        return ResponseData.successResponse(response);
    }
}
