package com.live.common.utils;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import java.security.SecureRandom;
import java.util.Random;
import java.util.UUID;

@Service
@Lazy(false)
public class IdGen {

    private static SecureRandom random = new SecureRandom();

    /**
     * 封装JDK自带的UUID, 通过Random数字生成, 中间无-分割.
     */
    public static String uuid() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    /**
     * 使用SecureRandom随机生成Long.
     */
    public static long randomLong() {
        return Math.abs(random.nextLong());
    }

    /**
     * 使用SecureRandom随机生成Long. ,有n 位数
     */
    public static String randomLong(int count) {
        String result = Math.abs(random.nextLong()) + "";
        return result.substring(0, count);
    }

    /**
     * 返回手机号码
     */
    private static String[] telFirst = ("134,135,136,137,138,139,147,150,151,152,157,158,159,182,183,184,187,188,198," +
            "130,131,132,145,155,156,166,171,175,176,185,186,166," +
            "133,149,153,173,177,180,181,189,199").split(",");

    private static int getNum(int start, int end) {
        return (int) (Math.random() * (end - start + 1) + start);
    }

    public static String getPhone() {
        int index = getNum(0, telFirst.length - 1);
        String first = telFirst[index];
        String second = String.valueOf(getNum(1, 888) + 10000).substring(1);
        String third = String.valueOf(getNum(1, 9100) + 10000).substring(1);
        return first + second + third;
    }

    /**
     * 生成多少范围的随机数 最小最大都包含 伪随机
     *
     * @param baseNum:基数，相加的底数
     * @param rangeNum:乘数，作为范围之用
     * @return
     */
    public static int generatorNum(int baseNum, int rangeNum) {
        return baseNum + (int) (Math.random() * (rangeNum - baseNum + 1));
    }

    /**
     * 新方法 0 至 max -1
     * @param maxRandom
     * @return
     */
    public static int randomUtil(int maxRandom){
        return new Random().nextInt(maxRandom);
    }

    public static void main(String[] args) {
        for (int i=0;i<10000;i++){

            String smsCode = IdGen.randomLong(6);
            System.out.println(smsCode);
        }
    }

}
