package com.live.job.entity.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class UUQiuMatchListDto {

    private String choose_date;

    private String choose_date_text;

    private List<UUQiuMatchInfo> list;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class UUQiuMatchInfo {

        private List<UUQiuMatchAnchorInfo> anchor_list;

        private String away_logo;

        private String away_name;

        private String away_score;

        private String home_logo;

        private String home_name;

        private String home_score;

        private String id;

        private String match_name;

        //比赛时间
        private String show_match_time;

        private String state;

        //足球 篮球
        private String type_text;

    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class UUQiuMatchAnchorInfo {
        private String avatar;
        private String nick_name;
        private Integer user_id;
    }

}
