package com.live.job.service.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.live.common.domain.entity.RobotMsg;
import com.live.common.domain.entity.Room;
import com.live.common.domain.request.SendMessageByRoomRequest;
import com.live.common.mapper.RobotMsgMapper;
import com.live.common.mapper.RoomMapper;
import com.live.common.service.HuanXinIMService;
import com.live.common.utils.ChatFakeMsgUtils;
import com.live.common.utils.IdGen;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Service
public class ChatTimedSendingServiceImpl {

    @Resource
    private RoomMapper roomMapper;
    @Resource
    private RobotMsgMapper robotMsgMapper;
    @Resource
    private HuanXinIMService huanXinIMService;
    @Resource
    private ThreadPoolTaskScheduler taskScheduler;

    //  @Scheduled(fixedRate = 10 * 60 * 1000)
    @Scheduled(cron = "01 01/01 * * * ?")
    public void timedSendingServiceImpl() {
        List<Room> rooms = roomMapper.selectList(Wrappers.<Room>lambdaQuery()
                .eq(Room::getDeleted, 0)
                .eq(Room::getType, 1)
                .eq(Room::getEnableFakeChat, 1)
        );

        for (String roomId : rooms.stream().map(Room::getHuanXinRoomId).collect(Collectors.toList())) {
            int randomSeconds = IdGen.randomUtil(60);
            taskScheduler.schedule(() -> sendFakeMessage(roomId), Instant.now().plusSeconds(randomSeconds));
        }
    }

    private void sendFakeMessage(String roomId) {
        List<RobotMsg> robotMsgs = returnFakeMsg();
        for (RobotMsg msg : robotMsgs) {
            String userName = StringUtils.isBlank(msg.getNickName()) ? ChatFakeMsgUtils.generateName() : msg.getNickName();

            huanXinIMService.sendMessageByRoom(SendMessageByRoomRequest.builder()
                    .ext(SendMessageByRoomRequest.Ext.builder()
                            .live_room_user_name(userName)
                            .user_level(getRandomLevel())
                            .user_nick(userName)
                            .build())
                    .from(userName)
                    .msg(SendMessageByRoomRequest.SendMessage.builder()
                            .msg(msg.getFakeMsg())
                            .type("txt")
                            .build())
                    .target_type("chatrooms")
                    .target(Collections.singletonList(roomId))
                    .build());
        }

    }

    private List<RobotMsg> returnFakeMsg() {
        int random = IdGen.randomUtil(6) + 1;

        return robotMsgMapper.selectList(Wrappers.<RobotMsg>lambdaQuery()
                .eq(RobotMsg::getMsgType, -1)
                .eq(RobotMsg::getDeleted, 0)
                .last(String.format(" ORDER BY RAND() LIMIT %s", random))
        );
    }

    private int getRandomLevel() {
        int random = IdGen.randomUtil(1000) + 1;
        if (random > 950) {
            return 7;
        } else if (random > 880) {
            return 6;
        } else if (random > 800) {
            return 5;
        } else if (random > 650) {
            return 4;
        } else if (random > 550) {
            return 3;
        } else if (random > 350) {
            return 2;
        } else {
            return 1;
        }
    }

}
