//package com.live.server.console.aspect;
//
//import com.alibaba.fastjson.JSON;
//import org.aspectj.lang.JoinPoint;
//import org.aspectj.lang.ProceedingJoinPoint;
//import org.aspectj.lang.annotation.*;
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//import org.springframework.stereotype.Component;
//import org.springframework.web.context.request.RequestContextHolder;
//import org.springframework.web.context.request.ServletRequestAttributes;
//
//import javax.servlet.http.HttpServletRequest;
//import javax.servlet.http.HttpServletResponse;
//import java.util.Arrays;
//import java.util.List;
//import java.util.stream.Collectors;
//
//@Aspect
//@Component
//public class LogAspect {
//    private final static Logger logger = LoggerFactory.getLogger(LogAspect.class);
//
//    @Pointcut("execution(public * com.live.console.*.controller.*.*(..))")
//    public void logPoint() {}
//
//
//    @Before("logPoint()")
//    public void doBefore(JoinPoint joinPoint) throws  Throwable{
//        // 开始打印请求日志
//        ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
//        if(attributes!=null){
//        HttpServletRequest request = attributes.getRequest();
//
//        // 打印请求相关参数
//        logger.info("========================================== Start ==========================================");
//        logger.info("URL            : {}", request.getRequestURL().toString());
//        logger.info("HTTP Method    : {}", request.getMethod());
//        logger.info("Class Method   : {}.{}", joinPoint.getSignature().getDeclaringTypeName(), joinPoint.getSignature().getName());
//            //排除不能进行序列化的类
//            List<Object> args= Arrays.stream(joinPoint.getArgs()).filter(v -> !(v instanceof HttpServletResponse || v instanceof HttpServletRequest)).collect(Collectors.toList());
//            logger.info("Request Args   : {}", JSON.toJSONString(args));
//
//        }
//    }
//
//    @After("logPoint()")
//    public void doAfter() throws Throwable {
//        logger.info("=========================================== End ===========================================");
//
//    }
//
//
//    @Around("logPoint()")
//    public Object doAround(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
//        long startTime = System.currentTimeMillis();
//        Object result = proceedingJoinPoint.proceed();
//        logger.info("Response Args  : {}", JSON.toJSONString(result));
//
//        logger.info("Time-Consuming : {} ms", System.currentTimeMillis() - startTime);
//        return result;
//    }
//
//
//
//
//}