package com.live.job.entity.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class CrawlAnchorSequoiaDto {

    private List<AnchorSequoiaInfo> list_data;

    private PageData page_data;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class PageData {
        private String totalCount;
        private Integer current_page;
        private Integer page_size;
        private Integer page_count;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class AnchorSequoiaInfo {
        private String nick_name;
        private String avatar;
        private String user_id;
        private String page_img;
        private String room_name;
        private String play_type;
        private String random_hot;
        private String total_hot;
        private String hots;
//                        "nick_name": "苍苍",
//                                "avatar": "http://hp-st.uuqiu.vip/img_source/users/20201015/fciq80oxalyx.png",
//                                "user_id": "10008",
//                                "page_img": "http://hp-st.uuqiu.vip/img_source/live/20210402/fcryylpy6gwc.png",
//                                "room_name": "CBA 辽宁vs浙江",
//                                "play_type": "0",
//                                "random_hot": "50000",
//                                "total_hot": "50000",
//                                "hots": "50000"
    }

}
