package com.live.common.domain.dto.api;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class LeaguePointsRankBasketballResponse {

    private List<StageBasketball> stages;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class StageBasketball {
        private String stageName;
        private List<GroupBasketball> groups;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class GroupBasketball {
        private String groupName;
        private List<RankBasketballResponse> rankInfos;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class RankBasketballResponse {
        private String teamName;
        private String teamIcon;
        private Integer wins;
        private Integer losts;
        private Integer pointsFor;
        private Integer pointsDiff;
        private Integer points;
    }

}
