package com.live.server.config;

import com.live.common.mapper.UserMapper;
import com.live.common.service.RedisUtilsService;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import javax.annotation.Resource;

@Configuration
public class IntercaptorConfig implements WebMvcConfigurer {

    @Resource
    private UserMapper userMapper;
    @Resource
    private RedisUtilsService redisUtilsService;

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(new JWTInterceptor(redisUtilsService, userMapper))
                //拦截的路径
                .addPathPatterns("/**")
                .excludePathPatterns("/swagger-resources/**", "/webjars/**", "/v2/**", "/swagger-ui.html/**")
                .excludePathPatterns("/common/**")
                .excludePathPatterns("/user/login", "/user/register", "/user/sendSms", "/user/userFeedback" , "/user/getFeedbackList",
                        "/user/loginByPc", "/user/registerByPc" ,"/user/forgotPassword", "/user/userInfoByIds", "/user/loginByPwd")
                .excludePathPatterns("/avatar/**")
                .excludePathPatterns("/download/**")
                .excludePathPatterns("/file/**")
                .excludePathPatterns("/match/getMatchHomeType", "/match/getMatchListBySportsId", "/match/getMatchInfo", "/match/matchInfoBasketball",
                        "/match/matchInfoFootball", "/match/getMatchSummaryById", "/match/getMatchLiveList", "/match/matchFootballOdds", "/match/matchBasketballOdds",
                        "/match/getMatchNewsById", "/match/getHotRankList", "/match/getHotRankInfoById","/match/getHotRankAssociate","/match/getMatchSportsType",
                        "/match/customMadeTeam")
                .excludePathPatterns("/room/getGiftList", "/room/getRoomInfo", "/room/getAnchorMatch", "/room/leaderboard", "/room/getHotAnchor", "/room/getChatMessage")
                .excludePathPatterns("/live/**")
                .excludePathPatterns("/article/**")
                .excludePathPatterns("/pcHome/**")
                .excludePathPatterns("/data/**")
                .excludePathPatterns("/platform/liveCutImgNotify")

        ;
    }
}