package com.live.job.entity.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class SportLive360ListDto {

//    "matchId": "349761",           // 渠道对应赛事ID
//            "matchTimeStamp": "1567598400",// 时间戳
//            "matchDate": "2014-05-01",     // 日期
//            "matchTime": "20:00",          // 时间
//            "matchState": "0",              // 0: 未开始，1:暂无信号 2：有信号
//            "catId": "football",         // 类别ID
//            "catName": "足球",             // 类别名称
//            "leagueId": "10",              // 对应渠道联赛ID
//            "leagueName": "中超",        // 联赛名称
//            "leagueNameEn": "csl",// 联赛英文名
//            "homeId": "83",                // 对应渠道主队ID
//            "homeName": "北京国安",            // 主队名
//            "homeNameEn": "Beijing Guoang",         // 主队英文名
//            "homeScore": "0",              // 主队得分
//            "awayId": "714",               // 对应渠道客队ID
//            "awayName": "上海上港",        // 客队名
//            "awayNameEn": "Shanghai Shanggang",     // 客队英文名
//            "awayScore": "0",              // 客队得分
//            "liveStreams": [   // 如果 为空表示无直播源, 一场比赛可能会有多条直播流，可能会先后接入, 定时拉取接口数据时，别忘记更新此字段！
//    {
//        "id": "a5d159fa5a080c17",  // 直播源ID
//            "type": 1,                 // 直播类型，0:标清直播，1：高清直播，2：中文高清
//            "name": "高清直播",
//    },
//    {
//        "id": "bbee31ca89c3fa44",
//            "type": 2,
//            "name": "中文高清",
//    }
//        ]

    private String matchId;  // 渠道对应赛事ID
    private String matchTimeStamp;// 时间戳
    private String matchDate;// 日期
    private String matchTime;// 时间
    private String catId;// 类别ID
    private String catName;// 类别名称
    private String leagueId;// 对应渠道联赛ID
    private String leagueName;// 联赛名称
    private String homeId;
    private String homeName;//主队名称
    private String homeScore;
    private String awayId;
    private String awayName;//客队名称
    private String awayScore;
    private String matchState;// 0: 未开始，1:暂无信号 2：有信号
    private List<Streams> liveStreams;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class Streams {
        private String id;
        private String type;
        private boolean state;
        private String name;
    }

}
