package com.live.job.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.live.common.domain.entity.*;
import com.live.common.enums.SystemConfigEnum;
import com.live.common.mapper.*;
import com.live.common.utils.DateUtil;
import com.live.common.utils.IdGen;
import com.live.common.utils.MD5Util;
import com.live.job.cache.MatchManager;
import com.live.job.constant.CrawlPlatformEnum;
import com.live.job.entity.dto.*;
import com.live.job.event.MatchOngoingEvent;
import com.live.job.service.CrawlMatchService;
import com.live.job.service.UpdateMatchStateService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.http.*;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;

import static org.springframework.http.MediaType.APPLICATION_JSON;

@Slf4j
@Service
public class CrawlLeYuServiceImpl implements CrawlMatchService {

    @Resource
    private TeamMapper teamMapper;
    @Resource
    private MatchMapper matchMapper;
    @Resource
    private RestTemplate restTemplate;
    @Resource
    private SportsMapper sportsMapper;
    @Resource
    private MatchLiveMapper matchLiveMapper;
    @Resource
    private TeamReportMapper teamReportMapper;
    @Resource
    private MatchRecentMapper matchRecentMapper;
    @Resource
    private FootballStatMapper footballStatMapper;
    @Resource
    private ThreadPoolExecutor threadPoolExecutor;
    @Resource
    private ThreadPoolTaskScheduler taskScheduler;
    @Resource
    private CrawlHistoryMapper crawlHistoryMapper;
    @Resource
    private TeamIntegralMapper teamIntegralMapper;
    @Resource
    private FootballEventMapper footballEventMapper;
    @Resource
    private MatchSummaryMapper matchSummaryMapper;
    @Resource
    private TeamCompetitionMapper teamCompetitionMapper;
    @Resource
    private PlayerCompetitionMapper playerCompetitionMapper;
    @Resource
    private UpdateMatchStateService updateMatchStateService;
    @Resource
    private ApplicationEventPublisher applicationEventPublisher;

    private final HttpHeaders headers;

    public CrawlLeYuServiceImpl() {
        headers = new HttpHeaders();
        headers.add("User-Agent", "Mozilla/5.0 (Linux; Android 6.0; Nexus 5 Build/MRA58N) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.90 Mobile Safari/537.36");
        headers.add("Connection", "keep-alive");
        headers.add("Host", "preview.611.com");
        headers.add("Origin", "http://m.611.com");
        headers.add("Referer", "http://m.611.com");
        headers.add("Cookie", "UM_distinctid=17868e64adf6d4-0e33987dfe691d-2f7c2e4d-54ab0-17868e64ae0cb0");

        headers.setAccept(Collections.singletonList(APPLICATION_JSON));
    }

    @Async
    @Override
    public void crawlScheduleMatch(String url) {
        log.info("定时爬取赛事");
        ResponseEntity<String> response = restTemplate.exchange(url, HttpMethod.GET, new HttpEntity<>(null, headers), String.class);
        if (response.getStatusCode() == HttpStatus.OK) {
            JSONObject jsonObject = JSONObject.parseObject(response.getBody());
            List<MatchToDayDto> matchToDayDto = JSONArray.parseArray(jsonObject.getString("data"), MatchToDayDto.class);
            for (MatchToDayDto matchToDay : matchToDayDto) {
                crawlScheduleMatch(matchToDay);
            }
        }
    }

    @Override
    public void crawlScheduleMatchByDay(String url, int day) {

    }

    @Override
    public void crawlIndexCompanyFootball(String url) {

    }

    @Override
    public void crawlIndexCompanyBasketball(String url) {

    }

    @Override
    public void crawlMatchStageScore(String url) {

    }

    @Override
    public void crawlScheduleArticle(String url) {

    }

    @Override
    public void updateMatchList() {
        updateMatchStateService.updateStateMatch();
    }

    /**
     * 爬取赛程-赛事详情
     *
     * @param matchToDay
     */
    private void crawlScheduleMatch(MatchToDayDto matchToDay) {
        try {
            String time = matchToDay.getGroupName();
            log.info("总赛事列表:{} 条", matchToDay.getList().size());
            for (MatchToDayInfoDto matchToDayInfo : matchToDay.getList()) {
                String matchInfoUrl = "http://preview.611.com/api/Data/getMatchData?id=" + matchToDayInfo.getMatchID() + "&sportType=" + matchToDayInfo.getSportType();

                Match match = matchMapper.selectOne(Wrappers.<Match>lambdaQuery()
                        .eq(Match::getCrawlUrl, matchInfoUrl)
                );

                CrawlHistory crawlHistory = crawlHistoryMapper.selectOne(Wrappers.<CrawlHistory>lambdaQuery()
                        .eq(CrawlHistory::getCrawlUrl, matchInfoUrl)
                );
                if ((matchToDayInfo.getSportType() == 0 && crawlHistory != null) || crawlHistory != null && match != null &&
                        (StringUtils.isNotBlank(match.getCompetitionAwayId()) || StringUtils.isNotBlank(match.getCompetitionHomeId()))) {
                    continue;
                }

                String sportId = saveSports(matchToDayInfo.getCompetetionName(), matchToDayInfo.getCompetetionShortName(), matchToDayInfo.getSportType());

                Team away = saveTeam(matchToDayInfo.getAway());
                Team home = saveTeam(matchToDayInfo.getHome());

                String matchId = IdGen.uuid();
                String homeCompetitionId = null;
                String awayCompetitionId = null;
                if (match != null) {
                    matchId = match.getId();
                    homeCompetitionId = match.getCompetitionHomeId();
                    awayCompetitionId = match.getCompetitionAwayId();
                }

                //比赛结束状态
                if (matchToDayInfo.getStatus() != 2 && !matchToDayInfo.getHasPlayedPart().contains("取消")) {
                    if (matchToDayInfo.getSportType() == 0) {
                        //足球
                        crawlFootball(matchInfoUrl, matchId, matchToDayInfo.getMatchID());
                    } else if (matchToDayInfo.getSportType() == 1) {
                        //篮球
                        ResponseEntity<String> response = restTemplate.getForEntity(matchInfoUrl, String.class);
                        if (response.getStatusCode() == HttpStatus.OK) {
                            JSONObject jsonObject = JSONObject.parseObject(response.getBody());
                            TeamCompetitionDto competitionDto = JSONArray.parseObject(jsonObject.getString("data"), TeamCompetitionDto.class);

                            for (TeamCompetitionDto.GameState gameState : competitionDto.getGameStat()) {
                                if (StringUtils.isNotBlank(gameState.getResult()) && gameState.getPlayerID() == null) {
                                    //团队得分总计
                                    if (gameState.getTeamID().equals(matchToDayInfo.getHome().getTeamId())) {
                                        homeCompetitionId = competitionTeam(homeCompetitionId, home.getId(), competitionDto.getGameInfo().getAScore(), gameState);
                                    } else {
                                        awayCompetitionId = competitionTeam(awayCompetitionId, away.getId(), competitionDto.getGameInfo().getBScore(), gameState);
                                    }
                                }
                            }

                            for (TeamCompetitionDto.GameState gameState : competitionDto.getGameStat()) {
                                if (gameState.getResult() == null && gameState.getPlayerID() != null) {
                                    //个人得分
                                    if (gameState.getTeamID().equals(matchToDayInfo.getHome().getTeamId())) {
                                        competitionPlayer(home.getId(), homeCompetitionId, gameState);
                                    } else {
                                        competitionPlayer(away.getId(), awayCompetitionId, gameState);
                                    }
                                }
                            }
                        }
                    }
                }
                if (matchToDayInfo.getStatus() == 3) {
                    try {
                        crawlHistoryMapper.insert(CrawlHistory.builder().crawlUrl(matchInfoUrl).build());
                    } catch (DuplicateKeyException d) {
                        //nothing
                    }
                }

                try {
                    if (match != null) {
                        match.setHomeScore(matchToDayInfo.getHome().getScore());
                        match.setAwayScore(matchToDayInfo.getAway().getScore());
                        match.setCompetitionStatus(matchToDayInfo.getStatus());
                        match.setCompetitionAwayId(awayCompetitionId);
                        match.setCompetitionHomeId(homeCompetitionId);
                        matchMapper.updateById(match);
                    } else {
                        matchMapper.insert(Match.builder()
                                .id(matchId)
                                .sportsId(sportId)
                                .awayId(away.getId())
                                .homeId(home.getId())
                                .awayScore(matchToDayInfo.getAway().getScore())
                                .homeScore(matchToDayInfo.getHome().getScore())
                                .matchTime(DateUtil.parse(time + " " + matchToDayInfo.getBeginTime(), DateUtil.YMDHM_))
                                .competitionName(matchToDayInfo.getCompetetionName())
                                .competitionShortName(matchToDayInfo.getCompetetionShortName())
                                .competitionStatus(matchToDayInfo.getStatus())
                                .competitionHomeId(homeCompetitionId)
                                .competitionAwayId(awayCompetitionId)
                                .crawlUrl(matchInfoUrl)
                                .categoryId(matchToDayInfo.getSportType() + ",")
                                .build());
                        log.info("抓取成功");
//                    if (matchToDayInfo.getStatus() != 3) {
//                        applicationEventPublisher.publishEvent(MatchOngoingEvent.builder().matchId(matchId)
//                                .time(System.currentTimeMillis())
//                                .matchTime(DateUtil.parse(time + " " + matchToDayInfo.getBeginTime(), DateUtil.YMDHM_))
//                                .sportsType(1).status(matchToDayInfo.getStatus()).build());
//                    }
                    }
                } catch (DuplicateKeyException d) {
                    //nothing
                }

                String saveMatchId = matchId;
                //赛前分析
                taskScheduler.schedule(() ->
                                matchBeforeAnalysis(saveMatchId, matchToDayInfo.getSportType(), matchToDayInfo),
                        Instant.now().plusSeconds(5));
                if (matchToDayInfo.getStatus() != 2) {
                    //直播地址
//                    taskScheduler.schedule(() ->
//                                    matchLive(saveMatchId, matchToDayInfo.getMatchID(), matchToDayInfo.getSportType()),
//                            Instant.now().plusSeconds(10));
                    //赛事概况
                    taskScheduler.schedule(() ->
                                    matchSummary(saveMatchId, matchToDayInfo.getMatchID(), matchToDayInfo.getSportType()),
                            Instant.now().plusSeconds(15));
                }
            }
        } catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    //直播 模块 赛事概况
    private void matchSummary(String matchId, int originalMatchId, int sportType) {
        Integer sort = null;
        int max = 3;
        try {
            do {
                String firstUrl = "http://preview.611.com/api/Live/GetLivingText?MatchID=" + originalMatchId + "&sportType=" + sportType + "&isMobile=0&Sort=" + sort;

                ResponseEntity<String> response = restTemplate.getForEntity(firstUrl, String.class);
                if (response.getStatusCode() == HttpStatus.OK) {
                    MatchSummaryListDto matchLiveDto = JSONArray.parseObject(response.getBody(), MatchSummaryListDto.class);
                    if (matchLiveDto == null)
                        return;
                    for (MatchSummaryListDto.MatchSummaryDto summaryDto : matchLiveDto.getData()) {
                        try {
                            matchSummaryMapper.insert(MatchSummary.builder()
                                    .matchId(matchId)
                                    .sort(summaryDto.getSort())
                                    .sourceId(summaryDto.getID())
                                    .message(summaryDto.getMsg())
                                    .sourceMatchId(summaryDto.getMatchID())
                                    .matchTime(summaryDto.getMatchTime())
                                    .build());
                        } catch (DuplicateKeyException e) {
                            //nothing
                            break;
                        }
                    }

                    if (matchLiveDto.getData().size() <= 0) {
                        break;
                    }
                    sort = matchLiveDto.getData().get(matchLiveDto.getData().size() - 1).getSort();
                    if (sportType == 1) {
                        //篮球
                        if (Math.min(max, sort) <= 1)
                            break;
                        max--;
                    }
                    log.info("爬取:{} 赛事概况成功", matchId);
                } else {
                    sort = 1;
                }
            } while (sort > 1);
        } catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    //比赛直播地址
    private void matchLive(String matchId, int originalMatchId, int sportType) {
        String matchLiveUrl = "http://preview.611.com/api/live/GetLiveSources?MatchID=" + originalMatchId + "&sportType=" + sportType;
        try {
            CrawlHistory crawlHistory = crawlHistoryMapper.selectOne(Wrappers.<CrawlHistory>lambdaQuery()
                    .eq(CrawlHistory::getCrawlUrl, matchLiveUrl)
            );
            if (crawlHistory != null) {
                return;
            }

            ResponseEntity<String> response = restTemplate.postForEntity(matchLiveUrl, new HttpEntity<>(null, headers), String.class);
            if (response.getStatusCode() == HttpStatus.OK) {
                MatchLiveDto teamReportDto = JSONArray.parseObject(response.getBody(), MatchLiveDto.class);
                if (teamReportDto != null) {
                    for (MatchLiveDto.MatchLiveResponse matchLive : teamReportDto.getData()) {
                        matchLiveMapper.insert(MatchLive.builder()
                                .matchId(matchId)
                                .sourceName(matchLive.getSourceName())
                                .sourceType(matchLive.getSourceType())
                                .sourceUrl(matchLive.getSourceUrl())
                                .build());
                    }
                    crawlHistoryMapper.insert(CrawlHistory.builder().crawlUrl(matchLiveUrl).build());
                }
            }
        } catch (Exception e) {
            log.warn("爬取比赛直播视频地址失败 - {} - {}", e.getMessage(), matchLiveUrl);
        }
    }

    private void matchBeforeAnalysis(String matchId, Integer sportType, MatchToDayInfoDto matchToDayInfo) {
        try {
            String matchInfoUrl = "http://preview.611.com/api/Live/getLiveMatchIData?MatchID=" + matchToDayInfo.getMatchID() + "&SportType=" + sportType + "&publishDate=&ModeType=4&page=1";
            CrawlHistory crawlHistory = crawlHistoryMapper.selectOne(Wrappers.<CrawlHistory>lambdaQuery()
                    .eq(CrawlHistory::getCrawlUrl, matchInfoUrl)
            );
            if (crawlHistory != null) {
                return;
            }

            Team away = saveTeam(matchToDayInfo.getAway());
            Team home = saveTeam(matchToDayInfo.getHome());

            ResponseEntity<String> response = restTemplate.postForEntity(matchInfoUrl, new HttpEntity<>(null, headers), String.class);
            if (response.getStatusCode() == HttpStatus.OK) {
                JSONObject jsonObject = JSONObject.parseObject(response.getBody());
                TeamReportDto teamReportDto = JSONArray.parseObject(jsonObject.getString("data"), TeamReportDto.class);
                if (teamReportDto != null) {
                    saveSection(matchToDayInfo.getHome().getTeamId(), home.getId(), away.getId(), matchId, teamReportDto);
                    crawlHistoryMapper.insert(CrawlHistory.builder().crawlUrl(matchInfoUrl).build());
                }
            }
        } catch (RuntimeException e) {
            log.error("新增{}比赛分析报错:{}", sportType == 1 ? "篮球" : "足球", e.getMessage());
        }
    }

    private void crawlFootball(String matchInfoUrl, String matchId, int originalMatchId) {
        ResponseEntity<String> response = restTemplate.getForEntity(matchInfoUrl, String.class);
        if (response.getStatusCode() == HttpStatus.OK) {
            JSONObject jsonObject = JSONObject.parseObject(response.getBody());
            FootballCompetitionDto competitionDto = JSONArray.parseObject(jsonObject.getString("data"), FootballCompetitionDto.class);

            //技术统计 团队得分总计
            for (FootballCompetitionDto.GameState gameState : competitionDto.getGameStat()) {
                try {
                    footballStatMapper.insert(FootballStat.builder()
                            .matchId(matchId)
                            .statAway(gameState.getStatAway())
                            .statHome(gameState.getStatHome())
                            .statName(gameState.getStatName())
                            .build());
                } catch (DuplicateKeyException e) {
                    //nothing
                } catch (RuntimeException e) {
                    log.error("新增足球比分统计时报错:{}", e.getMessage());
                }
            }

            //赛场事件
            for (FootballCompetitionDto.MatchGoal eventGoal : competitionDto.getGameGoalData().getMatchGoal()) {
                for (FootballCompetitionDto.TeamGoal teamGoal : eventGoal.getAway_Goal()) {
                    saveMatchEvent(teamGoal, matchId);
                }
                for (FootballCompetitionDto.TeamGoal teamGoal : eventGoal.getHome_Goal()) {
                    saveMatchEvent(teamGoal, matchId);
                }
            }
        }
        //视频集锦 / 回放
//        matchVideoCollection(matchId, originalMatchId, 0);
    }

    //比赛视频集锦
    private void matchVideoCollection(String matchId, Integer originalId, int sportsType) {
        try {
            String matchInfoUrl = "http://preview.611.com/api/Live/getLiveMatchIData?MatchID=" + originalId + "&SportType=" + sportsType + "&publishDate=&ModeType=6&page=1";

            CrawlHistory crawlHistory = crawlHistoryMapper.selectOne(Wrappers.<CrawlHistory>lambdaQuery()
                    .eq(CrawlHistory::getCrawlUrl, matchInfoUrl)
            );
            if (crawlHistory != null) {
                return;
            }

            ResponseEntity<String> response = restTemplate.postForEntity(matchInfoUrl, new HttpEntity<>(null, headers), String.class);
            if (response.getStatusCode() == HttpStatus.OK) {
                JSONObject jsonObject = JSONObject.parseObject(response.getBody());
                TeamCompetitionDto competitionDto = JSONArray.parseObject(jsonObject.getString("data"), TeamCompetitionDto.class);

            }

            crawlHistoryMapper.insert(CrawlHistory.builder().crawlUrl(matchInfoUrl).build());
        } catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    private void saveSection(String oldHomeId, String homeId, String awayId, String competitionId, TeamReportDto teamReportDto) {
        for (TeamReportDto.ReportDto reportDto : teamReportDto.getModeData().getListData()) {
            switch (reportDto.getSectionType()) {
                case 1:
                    //一手情报
                    for (TeamReportDto.LeagueMatch leagueMatch : reportDto.getLeagueMatchList()) {
                        String teamId = null;
                        if (leagueMatch.getTeamId().equals(oldHomeId)) {
                            teamId = homeId;
                        } else if (StringUtils.isBlank(leagueMatch.getTeamId())) {
                            continue;
                        } else {
                            teamId = awayId;
                        }
                        String badMsg = null;
                        String godMsg = null;
                        for (TeamReportDto.TeamInformation saveInfo : leagueMatch.getTeamInformation()) {
                            if (saveInfo.getIntelligenceName().equals("有利情报")) {
                                godMsg = saveInfo.getIntelligenceArr().stream().map(TeamReportDto.Text::getText).collect(Collectors.joining(""));
                            } else if (saveInfo.getIntelligenceName().equals("不利情报")) {
                                badMsg = saveInfo.getIntelligenceArr().stream().map(TeamReportDto.Text::getText).collect(Collectors.joining(""));
                            }
                        }
                        try {
                            teamReportMapper.insert(TeamReport.builder()
                                    .teamId(teamId)
                                    .badMsg(badMsg)
                                    .godMsg(godMsg)
                                    .msgMd5(MD5Util.string2MD5(godMsg + badMsg))
                                    .build());
                        } catch (RuntimeException e) {
                            log.error("新增赛事 一手情报 失败:{}", e.getMessage());
                        }
                    }
                    break;
                case 2:
                    //积分榜
                    for (TeamReportDto.LeagueMatch leagueMatch : reportDto.getLeagueMatchList()) {
                        String teamId = null;
                        if (leagueMatch.getTeamId().equals(oldHomeId)) {
                            teamId = homeId;
                        } else {
                            teamId = awayId;
                        }

                        String integralAway = null;
                        String integralHome = null;
                        String integralSum = null;
                        for (List<String> integ : leagueMatch.getLeagueMatchData()) {
                            if (integ.stream().anyMatch(b -> b.equals("总"))) {
                                integralSum = String.join(",", integ);
                            } else if (integ.stream().anyMatch(b -> b.equals("主"))) {
                                integralHome = String.join(",", integ);
                            } else {
                                integralAway = String.join(",", integ);
                            }
                        }
                        try {
                            teamIntegralMapper.insert(TeamIntegral.builder()
                                    .teamId(teamId)
                                    .integralAway(integralAway)
                                    .integralHeader(String.join(",", reportDto.getLeagueMatchHeader()))
                                    .integralHome(integralHome)
                                    .integralSum(integralSum)
                                    .build());
                        } catch (DuplicateKeyException e) {
                            //nothing
                        } catch (RuntimeException e) {
                            log.error("新增赛事 积分榜 失败:{}", e.getMessage());
                        }
                    }
                    break;
                case 3:
                    //分析数据
                    for (TeamReportDto.LeagueMatch leagueMatch : reportDto.getLeagueMatchList()) {
                        try {
                            matchRecentMapper.insert(MatchRecent.builder()
                                    .matchId(competitionId)
                                    .teamRecordLost(leagueMatch.getTeamRecordLost())
                                    .teamRecordName(leagueMatch.getTeamRecordName())
                                    .teamRecordTie(leagueMatch.getTeamRecordTie())
                                    .teamRecordWin(leagueMatch.getTeamRecordWin())
                                    .competitionData(JSON.toJSONString(leagueMatch.getCompetitionData()))
                                    .build());
                        } catch (DuplicateKeyException e) {
                            //nothing
                        } catch (RuntimeException e) {
                            log.error("新增赛事 分析数据 失败:{}", e.getMessage());
                        }
                    }
                    break;
            }
        }
    }

    private void saveMatchEvent(FootballCompetitionDto.TeamGoal teamGoal, String matchId) {
        try {
            footballEventMapper.insert(FootballEvent.builder()
                    .matchId(matchId)
                    .assistedName(teamGoal.getAssistedPname())
                    .downName(teamGoal.getDownname())
                    .eventName(teamGoal.getEname())
                    .minute(teamGoal.getMinute())
                    .pName(teamGoal.getPname())
                    .score(teamGoal.getScore())
                    .type(teamGoal.getType())
                    .upName(teamGoal.getUpname())
                    .build());
        } catch (DuplicateKeyException e) {
            //nothing
        } catch (RuntimeException e) {
            log.error("新增足球事件时报错:{}", e.getMessage());
        }
    }

    private synchronized String competitionTeam(String dbID, String teamId, String scoreSettle, TeamCompetitionDto.GameState gameState) {
        try {
            if (StringUtils.isNotBlank(dbID)) {
                TeamCompetition teamCompetition = teamCompetitionMapper.selectById(dbID);
                teamCompetition.setAssists(gameState.getAssists());
                teamCompetition.setAttackBoard(gameState.getAttackBoard());
                teamCompetition.setBlocks(gameState.getBlocks());
                teamCompetition.setError(gameState.getError());
                teamCompetition.setDefensiveBoard(gameState.getDefensiveBoard());
                teamCompetition.setFoul(gameState.getFoul());
                teamCompetition.setFreeThrowNum(gameState.getFreeThrowNum());
                teamCompetition.setFreeThrows(gameState.getFreeThrows());
                teamCompetition.setHomeOrAway(gameState.getHomeOrAway().equals("客场") ? 1 : 0);
                teamCompetition.setResult(gameState.getResult().equals("负") ? 1 : 0);
                teamCompetition.setScore(gameState.getScore());
                teamCompetition.setTeamId(teamId);
                teamCompetition.setThreeShotNum(gameState.getThreeShotNum());
                teamCompetition.setThreeShots(gameState.getThreeShots());
                teamCompetition.setTotalBoards(gameState.getTotalBoards());
                teamCompetition.setScoreSettle(scoreSettle);
                teamCompetition.setTwoScore(gameState.getTwoScore());
                teamCompetition.setSteals(gameState.getSteals());
                teamCompetitionMapper.updateById(teamCompetition);
            } else {
                dbID = IdGen.uuid();
                teamCompetitionMapper.insert(TeamCompetition.builder()
                        .id(dbID)
                        .assists(gameState.getAssists())
                        .attackBoard(gameState.getAttackBoard())
                        .blocks(gameState.getBlocks())
                        .error(gameState.getError())
                        .defensiveBoard(gameState.getDefensiveBoard())
                        .foul(gameState.getFoul())
                        .freeThrowNum(gameState.getFreeThrowNum())
                        .freeThrows(gameState.getFreeThrows())
                        .homeOrAway(gameState.getHomeOrAway().equals("客场") ? 1 : 0)
                        .result(gameState.getResult().equals("负") ? 1 : 0)
                        .score(gameState.getScore())
                        .shootNum(gameState.getShootNum())
                        .shots(gameState.getShots())
                        .steals(gameState.getSteals())
                        .scoreSettle(scoreSettle)
                        .teamId(teamId)
                        .threeShotNum(gameState.getThreeShotNum())
                        .threeShots(gameState.getThreeShots())
                        .totalBoards(gameState.getTotalBoards())
                        .twoScore(gameState.getTwoScore())
                        .build());
            }
        } catch (RuntimeException e) {
            e.printStackTrace();
            log.error("competitionTeam ERROR:{}", e.getMessage());
        }
        return dbID;
    }

    private synchronized void competitionPlayer(String tempId, String competitionId, TeamCompetitionDto.GameState gameState) {
        try {
            PlayerCompetition playerCompetition = playerCompetitionMapper.selectOne(Wrappers.<PlayerCompetition>lambdaQuery()
                    .eq(PlayerCompetition::getTeamCompetitionId, competitionId)
                    .eq(PlayerCompetition::getTeamId, tempId)
                    .eq(PlayerCompetition::getPlayerName, gameState.getPlayerName())
            );

            if (playerCompetition != null) {
                playerCompetition.setPlayingTime(gameState.getPlayingTime());
                playerCompetition.setAbsentReason(gameState.getAbsentReason());
                playerCompetition.setAssists(gameState.getAssists());
                playerCompetition.setAttackBoard(gameState.getAttackBoard());
                playerCompetition.setBlocks(gameState.getBlocks());
                playerCompetition.setError(gameState.getError());
                playerCompetition.setFoul(gameState.getFoul());
                playerCompetition.setFreeThrowNum(gameState.getFreeThrowNum());
                playerCompetition.setFreeThrows(gameState.getFreeThrows());
                playerCompetition.setHomeOrAway(gameState.getHomeOrAway().equals("客场") ? 1 : 0);
                playerCompetition.setShootNum(gameState.getShootNum());
                playerCompetition.setSteals(gameState.getSteals());
                playerCompetition.setScore(gameState.getScore());
                playerCompetition.setShootNum(gameState.getShootNum());
                playerCompetition.setThreeShotNum(gameState.getThreeShotNum());
                playerCompetition.setThreeShots(gameState.getThreeShots());
                playerCompetition.setTotalBoards(gameState.getTotalBoards());
                playerCompetitionMapper.updateById(playerCompetition);
            } else {
                playerCompetitionMapper.insert(PlayerCompetition.builder()
                        .id(IdGen.uuid())
                        .playerName(gameState.getPlayerName())
                        .playingTime(gameState.getPlayingTime())
                        .teamCompetitionId(competitionId)
                        .absentReason(gameState.getAbsentReason())
                        .assists(gameState.getAssists())
                        .attackBoard(gameState.getAttackBoard())
                        .blocks(gameState.getBlocks())
                        .teamId(tempId)
                        .error(gameState.getError())
                        .foul(gameState.getFoul())
                        .freeThrowNum(gameState.getFreeThrowNum())
                        .freeThrows(gameState.getFreeThrows())
                        .homeOrAway(gameState.getHomeOrAway().equals("客场") ? 1 : 0)
                        .score(gameState.getScore())
                        .shootNum(gameState.getShootNum())
                        .shots(gameState.getShots())
                        .steals(gameState.getSteals())
                        .threeShotNum(gameState.getThreeShotNum())
                        .threeShots(gameState.getThreeShots())
                        .totalBoards(gameState.getTotalBoards())
                        .build());
            }
        } catch (RuntimeException e) {
            log.error("competitionPlayer ERROR:{}", e.getMessage());
        }
    }

    private synchronized String saveSports(String competitionName, String competitionShortName, int sportsType) throws RuntimeException {
        try {
            Sports sports = sportsMapper.selectOne(Wrappers.<Sports>lambdaQuery()
                    .eq(Sports::getDeleted, 0)
                    .eq(Sports::getCompetitionShortName, competitionShortName)
            );
            if (sports != null) {
                return sports.getId();
            }

            String id = IdGen.uuid();
            sportsMapper.insert(Sports.builder()
                    .id(id)
                    .sportsId(sportsType)
                    .sportsName(sportsType == 1 ? "篮球" : "足球")
                    .competitionName(competitionName)
                    .competitionShortName(competitionShortName)
                    .build());
            return id;
        } catch (DuplicateKeyException d) {
            //nothing
        } catch (RuntimeException e) {
            e.printStackTrace();
            log.warn("新增 Sports 时报错:{}", e.getMessage());
        }
        throw new RuntimeException();
    }

    private synchronized Team saveTeam(MatchToDayInfoDto.Team team) throws RuntimeException {
        try {
            Team teamDb = teamMapper.selectOne(Wrappers.<Team>lambdaQuery()
                    .eq(Team::getDeleted, 0)
                    .eq(Team::getTeamName, team.getTeamName())
                    .eq(Team::getOriginalType, 0)
            );
            if (teamDb != null) {
                return teamDb;
            }

            String id = IdGen.uuid();
            Team saveTeam = Team.builder()
                    .id(id)
                    .originalId(team.getTeamId())
                    .teamIcon(team.getTeamLogo())
                    .teamName(team.getTeamName())
                    .originalType(0)
                    .build();
            teamMapper.insert(saveTeam);
            return saveTeam;
        } catch (RuntimeException e) {
            log.warn("新增球队时报错:{}", e.getMessage());
        }
        throw new RuntimeException();
    }

    @Override
    public void updateFootballState(String matchId, long time) {
        log.info("{} - 更新足球比赛状态", matchId);
        Match match = matchMapper.selectById(matchId);
        try {
            CrawlHistory crawlHistory = crawlHistoryMapper.selectOne(Wrappers.<CrawlHistory>lambdaQuery()
                    .eq(CrawlHistory::getCrawlUrl, match.getCrawlUrl())
            );
            if (crawlHistory != null && match.getCompetitionStatus() == 3 || StringUtils.isBlank(match.getCrawlUrl())) {
                return;
            }

            ResponseEntity<String> response = restTemplate.exchange(match.getCrawlUrl(), HttpMethod.GET, new HttpEntity<>(null, headers), String.class);
            if (response.getStatusCode() == HttpStatus.OK) {
                JSONObject jsonObject = JSONObject.parseObject(response.getBody());
                FootballCompetitionDto competitionDto = JSONArray.parseObject(jsonObject.getString("data"), FootballCompetitionDto.class);

                if (competitionDto.getGameInfo().getStatus() == 0) {
                    //未开始
                    log.info("{} - 未开始", matchId);
                } else if (competitionDto.getGameInfo().getStatus() == 10 || competitionDto.getGameInfo().getStatus() == 13
                        || competitionDto.getGameInfo().getStatus() == 9 || competitionDto.getGameInfo().getStatus() == 19) {
                    try {
                        crawlHistoryMapper.insert(CrawlHistory.builder().crawlUrl(match.getCrawlUrl()).build());
                    } catch (DuplicateKeyException d) {
                        //nothing
                    }
                    MatchManager.getInstance().removeMatchEvent(matchId);
                    match.setCompetitionStatus(3);
                    match.setAwayScore(competitionDto.getGameInfo().getAwayScore());
                    match.setHomeScore(competitionDto.getGameInfo().getHomeScore());
                    matchMapper.updateById(match);
                    log.info("更新足球比赛完成");
                    return;
                } else {
                    log.info("足球 {} - 其它状态 - {}", matchId, competitionDto.getGameInfo().getStatus());
                    if (match.getCompetitionStatus() != 1) {
                        match.setCompetitionStatus(1);
                        matchMapper.updateById(match);
                    }
                }
            } else {
                log.error("赛事请求异常:{}", matchId);
            }
        } catch (Exception e) {
            log.error("更新足球比赛时报错:{} - {}", e.getMessage(), matchId);
        }
//        applicationEventPublisher.publishEvent(MatchOngoingEvent.builder().matchId(matchId).time(time).matchTime(match.getMatchTime()).sportsType(0).status(1).build());
    }

    @Override
    public void updateBasketballState(String matchId, long time) {
        log.info("更新篮球比赛状态");
        Match match = matchMapper.selectById(matchId);
        try {
            CrawlHistory crawlHistory = crawlHistoryMapper.selectOne(Wrappers.<CrawlHistory>lambdaQuery()
                    .eq(CrawlHistory::getCrawlUrl, match.getCrawlUrl())
            );
            if (crawlHistory != null && match.getCompetitionStatus() == 3 || StringUtils.isBlank(match.getCrawlUrl())) {
                return;
            }

            //比赛结束状态
            ResponseEntity<String> response = restTemplate.exchange(match.getCrawlUrl(), HttpMethod.GET, new HttpEntity<>(null, headers), String.class);
            if (response.getStatusCode() == HttpStatus.OK) {
                JSONObject jsonObject = JSONObject.parseObject(response.getBody());
                TeamCompetitionDto competitionDto = JSONArray.parseObject(jsonObject.getString("data"), TeamCompetitionDto.class);

                if (competitionDto.getGameInfo().getStatus() == 0) {
                    //未开始
                    log.info("{} - 未开始", matchId);
                } else if (competitionDto.getGameInfo().getStatus() == 9 || competitionDto.getGameInfo().getStatus() == 13) {
                    try {
                        crawlHistoryMapper.insert(CrawlHistory.builder().crawlUrl(match.getCrawlUrl()).build());
                    } catch (DuplicateKeyException e) {
                        //
                    }
                    MatchManager.getInstance().removeMatchEvent(matchId);
                    log.info("更新篮球比赛完成");
                    String[] homeScore = competitionDto.getGameInfo().getAScore().split(",");
                    String[] awayScore = competitionDto.getGameInfo().getBScore().split(",");

                    match.setAwayScore(Integer.parseInt(homeScore[0]));
                    match.setHomeScore(Integer.parseInt(awayScore[0]));
                    match.setCompetitionStatus(3);
                    matchMapper.updateById(match);
                    return;
                } else {
                    log.info("篮球 {} - 其它状态 - {}", matchId, competitionDto.getGameInfo().getStatus());
                    if (match.getCompetitionStatus() != 1) {
                        match.setCompetitionStatus(1);
                        matchMapper.updateById(match);
                    }
                }
            } else {
                log.info("赛事请求异常:{}", matchId);
            }
        } catch (RuntimeException e) {
            log.error("更新篮球比赛时报错:{} - {}", e.getMessage(), JSON.toJSONString(match));
        }
//        applicationEventPublisher.publishEvent(MatchOngoingEvent.builder().matchId(matchId).time(time).matchTime(match.getMatchTime()).sportsType(1).status(1).build());
    }

    @Override
    public String getPlatform() {
        return CrawlPlatformEnum.LeYu.getCode();
    }

}
