package com.live.common.domain.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@TableName("t_sys_menu")
public class SysMenu {

    private static final  long serialVersionUID=1L;

    /**
     * 菜单主键
     */
    @TableId(value = "id",type= IdType.AUTO)
    private Integer id;

    /**
     * 菜单名称
     */
    private String name;

    /**
     * 菜单权限url
     */
    private String path;

    /**
     * 前端URL
     */
    private String jumpPath;

    /**
     * 排序
     */
    private Integer sort;

    /**
     * 菜单类型
     */
    private Integer type;


    /**
     * 菜单栏目描述
     */
    private String menuDes;

    /**
     * 创建人
     */
    private String  createBy;
    /**
     * '创建时间'
     */
    private Date createTime;
    /**
     * '更新时间'
     */
    private Date update_time;
    /**
     * '是否删除' 默认0未删除
     */
    private Integer  deleted;

}
