package com.live.common.utils;

import com.live.common.exception.CommonException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.PostConstruct;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

@Slf4j
@Component
public class FileUtils {

    private static FileUtils holder;

    @PostConstruct
    public void init() {
        holder = this;
    }

//    public static String copyFile(String  sourceStr,String dest,String fileRealName ){
//
//        File source = new File(sourceStr);
//        //source是文件，则用字节输入输出流复制文件
//      if(source.isFile()){
//          FileInputStream fis = null;
//          try {
//              fis = new FileInputStream(source);
//
//          //创建新的文件，保存复制内容，文件名称与源文件名称一致
//            File dfile = new File(dest+fileRealName + File.separator  + fileRealName + ".jpg");
//            if(!dfile.exists()){
//                dfile.createNewFile();
//            }
//
//            FileOutputStream fos = new FileOutputStream(dfile);
//            // 读写数据
//            // 定义数组
//            byte[] b = new byte[1024];
//            // 定义长度
//            int len;
//            // 循环读取
//            while ((len = fis.read(b))!=-1) {
//                // 写出数据
//                fos.write(b, 0 , len);
//            }
//
//            //关闭资源
//            fos.close();
//            fis.close();
//          String replace = dfile.getAbsolutePath().replace(holder.config.getImageReplacePath(), "");
//          return replace;
//          } catch (Exception e) {
//              log.info("相同文件copy------------->{}",e.getMessage());
//              e.printStackTrace();
//          }
//        }
//        return "";
//    }


    /**
     * 根据文件目录写入文件
     */
    public  static  void  getFolderByFile(String sourceFile,String fileName){
        File file=new File(sourceFile);
        try {
            String canonicalPath = file.getParent();
            File dfile = new File(canonicalPath+File.separator +fileName);
            if(!dfile.exists()){
                dfile.createNewFile();
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }


    /**
     * 通过文件路径直接修改文件名
     *
     * @param filePath    需要修改的文件的完整路径
     * @return
     */
    public static void fixFileName(String filePath) throws CommonException {
        File f = new File(filePath);
        // 判断原文件是否存在（防止文件名冲突）
        if (!f.exists()) {
            throw  new CommonException("修改不存在文件");
        }

        String fileName = f.getName();
        String name = fileName.substring(0,fileName.lastIndexOf("."))+"isUpdate";
        String substring = fileName.substring(fileName.lastIndexOf("."), fileName.length());
        File nf = new File(f.getParent()+File.separator+name+substring);
        try {
            f.renameTo(nf);
        } catch (Exception err) {
            err.printStackTrace();
            log.info("文件名字修改失败------------>{}",err.getMessage());
        }
    }


    /**
     *
     * @param file 文件
     * @param path 文件存放路径
     * @param
     * @return
     */
    public static  String upload(MultipartFile file, String path,String fileName){

        //1.读取系统时间
        Calendar calendar=Calendar.getInstance();
        Date time=calendar.getTime();

        //2.格式化系统时间
        SimpleDateFormat format=new SimpleDateFormat("yyyy-MM-dd");

        //使用原文件名
        String s = format.format(time) + "/" + FileNameUtils.getUUIDFileName(fileName);
        String realPath=path+"/"+ s;

        String resorcePath="/play/img/"+ s;

        File refile=new File(realPath);

        if(!refile.getParentFile().exists()){
            refile.getParentFile().mkdirs();
        }

        try {
            file.transferTo(refile);
            return resorcePath;
        }catch (IllegalStateException e){
            e.printStackTrace();
            return "上传失败";
        }catch (IOException e){
            e.printStackTrace();
            return "上传失败";
        }
    }

    /**
     * apk包上传
     * @param file
     * @param path
     * @return
     */
    public static  String uploadApk(MultipartFile file,String path,String fileName){

        //1.读取系统时间
        Calendar calendar=Calendar.getInstance();
        Date time=calendar.getTime();

        //2.格式化系统时间
        SimpleDateFormat format=new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        SimpleDateFormat format1=new SimpleDateFormat("yyyyMMddHHmmss");

        String resFileName="lds-"+format1.format(time)+FileNameUtils.getFileName(fileName);

        //使用原文件名
        String realPath=path+"/"+ format.format(time)+"/"+resFileName;

        String resorcePath="/play/apk/"+ format.format(time)+"/"+resFileName;

        File refile=new File(realPath);

        if(!refile.getParentFile().exists()){
            refile.getParentFile().mkdirs();
        }

        try {
            file.transferTo(refile);
            return resorcePath;
        }catch (IllegalStateException | IOException e){
            e.printStackTrace();
            return "上传失败";
        }
    }

    /**
     * 电影封面图片上传
     * @param file
     * @param path
     * @param fileName
     * @return
     */
    public static  String uploadMovie(MultipartFile file, String path,String fileName){
        //1.读取系统时间
        Calendar calendar=Calendar.getInstance();
        Date time=calendar.getTime();

        //2.格式化系统时间
        SimpleDateFormat format=new SimpleDateFormat("yyyy-MM-dd");

        //使用原文件名
        String s = format.format(time) + "/" + FileNameUtils.getUUIDFileName(fileName);
        String realPath=path+ s;

        String resorcePath=path+ s;

        String desResorcePath=path + s+".en";

        File refile=new File(realPath);

        if(!refile.getParentFile().exists()){
            refile.getParentFile().mkdirs();
        }

        try {
            file.transferTo(refile);
            PhotoIoUtils.decodeimg(resorcePath,desResorcePath);
            return desResorcePath;
        }catch (IllegalStateException | IOException e){
            e.printStackTrace();
            return "上传失败";
        }
    }

}
