package com.live.console.config;

import com.alibaba.fastjson.JSON;
import com.auth0.jwt.exceptions.AlgorithmMismatchException;
import com.auth0.jwt.exceptions.SignatureVerificationException;
import com.auth0.jwt.exceptions.TokenExpiredException;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.live.common.constant.RedisKeySplicing;
import com.live.common.domain.ResponseData;
import com.live.common.domain.entity.SysUser;
import com.live.common.exception.ExceptionCode;
import com.live.common.service.RedisUtilsService;
import com.live.common.utils.JWTUtils;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

public class JWTInterceptor implements HandlerInterceptor {

    private RedisUtilsService redisUtilsService;

    public JWTInterceptor(RedisUtilsService redisUtilsService){
        this.redisUtilsService = redisUtilsService;
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String token = request.getHeader("token");
        if(StringUtils.isEmpty(token)){
            renderJson(response, ResponseData.fail400Response("请先登录"));
            return false;
        }
        try {
            SysUser sysUser = JWTUtils.verifierTokenBySysUser(token);
            if(!redisUtilsService.existsKey(RedisKeySplicing.getUserToken(sysUser.getUsername()))){
                renderJson(response, ResponseData.failResponse(ExceptionCode.LOGIN_INVALID_STATUS_CODE, "Token 失效请重新登录"));
                return false;
            }
        } catch (SignatureVerificationException | AlgorithmMismatchException e) {
            renderJson(response, ResponseData.failResponse(ExceptionCode.LOGIN_INVALID_STATUS_CODE, "Token 无效"));
            return false;
        } catch (TokenExpiredException e) {
            renderJson(response, ResponseData.failResponse(ExceptionCode.LOGIN_INVALID_STATUS_CODE, "Token 失效请重新登录"));
            return false;
        } catch (Exception e) {
            renderJson(response, ResponseData.failResponse(ExceptionCode.LOGIN_INVALID_STATUS_CODE, "请先登录"));
            return false;
        }
        return true;
    }

    private void renderJson(HttpServletResponse response, Object jsonObject) {
        try {
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            PrintWriter writer = response.getWriter();
            writer.write(JSON.toJSONString(jsonObject));
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}