package com.live.job.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.live.common.domain.entity.Article;
import com.live.common.domain.entity.CrawlHistory;
import com.live.common.domain.entity.Tag;
import com.live.common.domain.entity.User;
import com.live.common.mapper.ArticleMapper;
import com.live.common.mapper.CrawlHistoryMapper;
import com.live.common.mapper.TagMapper;
import com.live.common.service.UserService;
import com.live.common.utils.DateUtil;
import com.live.common.utils.IdGen;
import com.live.job.constant.CrawlPlatformEnum;
import com.live.job.entity.dto.TemporarilyInfo;
import com.live.job.service.CrawlMatchService;
import lombok.extern.slf4j.Slf4j;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.*;
import java.util.concurrent.ThreadPoolExecutor;

@Slf4j
@Service
public class Crawl24ZBWServiceImpl implements CrawlMatchService {

    @Resource
    private TagMapper tagMapper;
    @Resource
    private UserService userService;
    @Resource
    private ArticleMapper articleMapper;
    @Resource
    private CrawlHistoryMapper crawlHistoryMapper;
    @Resource
    private ThreadPoolExecutor threadPoolExecutor;

    @Override
    public void crawlScheduleMatch(String url) {

    }

    @Override
    public void crawlScheduleMatchByDay(String url, int day) {

    }

    @Override
    public void crawlIndexCompanyFootball(String url) {

    }

    @Override
    public void crawlIndexCompanyBasketball(String url) {

    }

    @Override
    public void crawlMatchStageScore(String url) {

    }

    @Override
    public void crawlScheduleArticle(String jUrl) {
        try {
            Map<String, TemporarilyInfo> coverMap = new HashMap<>();
            for (int i = 1; i < 51; i++) {
                String url = jUrl + "page/" + i + "/";
                try {
                    Document doc = Jsoup.connect(url)
                            .timeout(10000)
                            .userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.77 Safari/537.36")
                            .get();

                    Element newsList = doc.getElementsByClass("news_list").first();

                    Elements titleList = newsList.getElementsByClass("block_img");
                    String siteUrl = url.substring(0, url.indexOf(".com") + 4);
                    for (Element title : titleList) {
                        String jumpUrl = title.getElementsByTag("a").first().attr("href");
                        String cover = title.getElementsByTag("img").first().attr("src");
                        String releaseTime = title.getElementsByTag("time").text();

                        coverMap.put(siteUrl + jumpUrl.trim(), TemporarilyInfo.builder()
                                .cover(cover)
                                .releaseTime(releaseTime)
                                .build());
                    }

                    Thread.sleep(1000);
                } catch (Exception e) {
                    log.error("crawlScheduleArticle error:{} - {}", e.getMessage(), url);
                }
            }
            //处理详情页
            for (String infoUrl : coverMap.keySet()) {
                CrawlHistory crawlHistory = crawlHistoryMapper.selectOne(Wrappers.<CrawlHistory>lambdaQuery()
                        .eq(CrawlHistory::getCrawlUrl, infoUrl)
                );
                if (crawlHistory != null) {
                    continue;
                }

                threadPoolExecutor.execute(() -> {
                    try {
                        dealWithPcInfo(infoUrl, coverMap.get(infoUrl));
                    } catch (IOException e) {
                        log.error("爬取失败链接:{} errorInfo:{}", infoUrl, e.getMessage());
                    }
                });
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void dealWithPcInfo(String url, TemporarilyInfo temporarilyInfo) throws RuntimeException, IOException {
        Document doc = Jsoup.connect(url)
                .timeout(30000)
                .userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.90 Safari/537.36")
                .get();

        Element videoBox = doc.getElementsByClass("play_video_box").first();
        String title;
        String content;
        int contentType = 0;
        if (videoBox != null) {
            title = videoBox.getElementsByClass("room_video_title").first().getElementsByTag("h2").text();

            Element video = videoBox.getElementsByClass("room_video").first();
            if (video == null) {
                return;
            }
            Element videoEle = video.getElementsByTag("a").first();
            if(videoEle == null)
                return;

            content = videoEle.attr("href");
            String videoImgUrl = video.getElementsByTag("img").first().attr("src");

            String time = videoBox.getElementsByTag("time").text();
            temporarilyInfo.setReleaseTime(time);
            contentType = 1;
        } else {
            title = doc.getElementsByTag("h1").first().text();

            Element bodyText = doc.getElementsByClass("articles_text").first();

            String time = bodyText.getElementsByTag("time").text();
            time = time.substring(time.length() - 5);
            temporarilyInfo.setReleaseTime(temporarilyInfo.getReleaseTime() + " " + time);

            content = bodyText.html();
            if (content.contains("<time>")) {
                String between = content.substring(content.indexOf("<time>"), content.indexOf("</time>") + 7);
                content = content.replace(between, "");
            }
            if (content.contains("<p><strong>")) {
                String betweenLastHtml = content.substring(content.indexOf("<p><strong>"));
                content = content.replace(betweenLastHtml, "");
            }
        }

        Element tagText = null;
        if (contentType == 1) {
            tagText = doc.getElementsByClass("room_video_title").first();
        } else {
            tagText = doc.getElementsByClass("articles_tag_text").first();
        }
        StringBuilder tagId = new StringBuilder();
        if (tagText != null) {
            Elements tags = tagText.getElementsByTag("li");
            List<String> tagsList = new ArrayList<>();
            for (Element tag : tags) {
                try {
                    String tagName = tag.getElementsByTag("a").first().text();
                    tagsList.add(tagName);
                    tagMapper.insert(Tag.builder()
                            .tagType(1)
                            .tagName(tagName)
                            .build());
                } catch (DuplicateKeyException e) {
                    //nothing
                } catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
            for (String tagName : tagsList) {
                Tag tagDb = tagMapper.selectOne(Wrappers.<Tag>lambdaQuery()
                        .eq(Tag::getTagName, tagName)
                        .eq(Tag::getTagType, 1)
                );
                tagId.append(tagDb.getId()).append(",");
            }
        }

        try {
            User user = userService.getRandomAuthor();

            articleMapper.insert(Article.builder()
                    .title(title)
                    .link(url)
                    .authorId(user.getId())
                    .authorName(user.getUserName())
                    .picUrl(temporarilyInfo.getCover())
                    .content(content)
                    .tagId(tagId.toString())
                    .createTime(new Date())
                    .contentType(contentType)
                    .releaseTime(DateUtil.parse(temporarilyInfo.getReleaseTime(), DateUtil.YMDHM_))
                    .fakeLike(IdGen.generatorNum(30, 900))
                    .build());
            crawlHistoryMapper.insert(CrawlHistory.builder().crawlUrl(url).build());
        } catch (DuplicateKeyException e) {
            //nothing
        }
    }

    @Override
    public void updateMatchList() {

    }

    @Override
    public void updateFootballState(String matchId, long time) {

    }

    @Override
    public void updateBasketballState(String matchId, long time) {

    }

    @Override
    public String getPlatform() {
        return CrawlPlatformEnum.ARTICLE24BWZ.getCode();
    }
}
