//package com.live.server.controller;
//
//import com.live.common.domain.ResponseData;
//import com.live.common.domain.ResultPage;
//import com.live.common.domain.request.CommonPage;
//import com.live.common.domain.request.CommonStringId;
//import com.live.common.domain.request.TopLiveRequest;
//import com.live.common.domain.request.VideoRecommendRequest;
//import com.live.common.service.RoomService;
//import io.swagger.annotations.Api;
//import io.swagger.annotations.ApiOperation;
//import io.swagger.annotations.ApiResponse;
//import io.swagger.annotations.ApiResponses;
//import lombok.extern.slf4j.Slf4j;
//import org.springframework.web.bind.annotation.*;
//
//import javax.annotation.Resource;
//import javax.servlet.http.HttpServletRequest;
//import java.util.ArrayList;
//
//@Slf4j
//@CrossOrigin
//@RestController
//@RequestMapping("/live")
//@Api(tags = "首页直播接口 API 文档")
//public class HomeLiveController {
//
//    @Resource
//    private RoomService roomService;
//
//    @PostMapping(value = "/getBannerList")
//    @ApiOperation(value = "获取头部轮播图")
//    @ApiResponses({
//            @ApiResponse(code = 200, message = "成功处理请求"),
//            @ApiResponse(code = 401, message = "没有权限访问该服务"),
//            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
//            @ApiResponse(code = 404, message = "未发现该服务"),
//            @ApiResponse(code = 500, message = "服务器内部错误")
//    })
//    public ResponseData<?> getBannerList(HttpServletRequest request) {
//        return roomService.getBannerList(request);
//    }
//
//    @PostMapping(value = "/getLiveStreamingToPc")
//    @ApiOperation(value = "PC获取主页正在直播列表")
//    @ApiResponses({
//            @ApiResponse(code = 200, message = "成功处理请求"),
//            @ApiResponse(code = 401, message = "没有权限访问该服务"),
//            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
//            @ApiResponse(code = 404, message = "未发现该服务"),
//            @ApiResponse(code = 500, message = "服务器内部错误")
//    })
//    public ResponseData<?> getLiveStreamingToPc(HttpServletRequest request) {
//        return roomService.getLiveStreamingToPc(request);
//    }
//
//    @PostMapping(value = "/getTopMatchList")
//    @ApiOperation(value = "获取头部赛程列表")
//    @ApiResponses({
//            @ApiResponse(code = 200, message = "成功处理请求"),
//            @ApiResponse(code = 401, message = "没有权限访问该服务"),
//            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
//            @ApiResponse(code = 404, message = "未发现该服务"),
//            @ApiResponse(code = 500, message = "服务器内部错误")
//    })
//    public ResponseData<?> getTopMatchList(HttpServletRequest request) {
//        return roomService.getTopMatchList(request);
//    }
//
//    @PostMapping(value = "/getHotLiveList")
//    @ApiOperation(value = "获取正在热播列表")
//    @ApiResponses({
//            @ApiResponse(code = 200, message = "成功处理请求"),
//            @ApiResponse(code = 401, message = "没有权限访问该服务"),
//            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
//            @ApiResponse(code = 404, message = "未发现该服务"),
//            @ApiResponse(code = 500, message = "服务器内部错误")
//    })
//    public ResponseData<?> getHotLiveList(@RequestBody CommonPage commonPage, HttpServletRequest request) {
//        return roomService.getHotLiveList(commonPage, request);
//    }
//
//    @PostMapping(value = "/getTopLiveList")
//    @ApiOperation(value = "获取头部直播列表 /match/getTitleTab 接口 type null 或 -1 全部")
//    @ApiResponses({
//            @ApiResponse(code = 200, message = "成功处理请求"),
//            @ApiResponse(code = 401, message = "没有权限访问该服务"),
//            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
//            @ApiResponse(code = 404, message = "未发现该服务"),
//            @ApiResponse(code = 500, message = "服务器内部错误")
//    })
//    public ResponseData<?> getTopLiveList(@RequestBody TopLiveRequest topLiveRequest, HttpServletRequest request) {
//        return roomService.getTopLiveList(topLiveRequest, request);
//    }
//
////    @PostMapping(value = "/getBasketballMatchList")
////    @ApiOperation(value = "获取头部篮球直播列表")
////    @ApiResponses({
////            @ApiResponse(code = 200, message = "成功处理请求"),
////            @ApiResponse(code = 401, message = "没有权限访问该服务"),
////            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
////            @ApiResponse(code = 404, message = "未发现该服务"),
////            @ApiResponse(code = 500, message = "服务器内部错误")
////    })
////    public ResponseData<?> getBasketballMatchList(@RequestBody CommonPage commonPage, HttpServletRequest request) {
////        return roomService.getBasketballMatchList(commonPage, request);
////    }
////
////    @PostMapping(value = "/getFootballMatchList")
////    @ApiOperation(value = "获取头部足球直播列表")
////    @ApiResponses({
////            @ApiResponse(code = 200, message = "成功处理请求"),
////            @ApiResponse(code = 401, message = "没有权限访问该服务"),
////            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
////            @ApiResponse(code = 404, message = "未发现该服务"),
////            @ApiResponse(code = 500, message = "服务器内部错误")
////    })
////    public ResponseData<?> getFootballMatchList(@RequestBody CommonPage commonPage, HttpServletRequest request) {
////        return roomService.getFootballMatchList(commonPage, request);
////    }
//
////    @PostMapping(value = "/getOtherMatchList")
////    @ApiOperation(value = "获取头部其它直播列表")
////    @ApiResponses({
////            @ApiResponse(code = 200, message = "成功处理请求"),
////            @ApiResponse(code = 401, message = "没有权限访问该服务"),
////            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
////            @ApiResponse(code = 404, message = "未发现该服务"),
////            @ApiResponse(code = 500, message = "服务器内部错误")
////    })
////    public ResponseData<?> getOtherMatchList(@RequestBody CommonPage commonPage, HttpServletRequest request) {
////        return ResponseData.successResponse(new ResultPage<>(commonPage.getPageNum(),
////                commonPage.getPageSize(), 0, new ArrayList<>()));
////    }
//
//    @PostMapping(value = "/getVideoRecommendList")
//    @ApiOperation(value = "精彩推荐 / 视频推荐 再房间里带房间ID,不在则传空")
//    @ApiResponses({
//            @ApiResponse(code = 200, message = "成功处理请求"),
//            @ApiResponse(code = 401, message = "没有权限访问该服务"),
//            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
//            @ApiResponse(code = 404, message = "未发现该服务"),
//            @ApiResponse(code = 500, message = "服务器内部错误")
//    })
//    public ResponseData<?> getVideoRecommendList(@RequestBody VideoRecommendRequest commonPage, HttpServletRequest request) {
//        return roomService.getVideoRecommendList(commonPage, request);
//    }
//
//}
