package com.live.job.entity.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class AlStatFootballStatDto {

    private String state;

    private List<AlStatFootballStatMatch> matchs;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class AlStatFootballStatMatch{
        private Integer id;
        private String startTime;
        private Integer homeTeamId;
        private String homeTeamName;
        private Integer awayTeamId;
        private String awayTeamName;
        private List<AlStatFootballStatStats> stats;
    }
    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class AlStatFootballStatStats{
        private Integer id;
        private Integer teamId;
        private String homeAway;
        private String formation;
        //评分
        private Double rate;
        //进球
        private Integer goals;
        //丢球
        private Integer goalsLost;
        //助攻次数
        private Integer assists;
        //点球得分
        private Integer penaltyScored;
        //射失点球
        private Integer penaltyMissd;
        //扑出点球
        private Integer penaltySaved;
        //黄牌
        private Integer yelCards;
        //红牌
        private Integer redCards;
        //射门次数
        private Integer shots;
        //射正次数
        private Integer shotsOT;
        //射偏次数
        private Integer shotsOffTag;
        //射门被封堵次数
        private Integer shotsBlocked;
        //击中门框次数
        private Integer shotsOnPost;
        //关键传球次数
        private Integer keyPasses;
        //成功过人次数
        private Integer dribbles;
        //尝试过人次数
        private Integer dribblesAttempted;
        //过人成功率（百分比）
        private Double dribblesSucc;
        //被突破次数
        private Integer dribbledPast;
        //被侵犯次数
        private Integer fouled;
        //越位次数
        private Integer offsides;
        //被抢断次数
        private Integer disp;
        //失误次数
        private Integer unsTouches;
        //抢断成功次数
        private Integer tackles;
        //尝试抢断次数
        private Integer tacklesAttempted;
        //抢断成功率（百分比）
        private Double tacklesSucc;
        //拦截次数
        private Integer interceptions;
        //解围次数
        private Integer clearances;
        //封堵射门次数
        private Integer blockShots;
        //犯规次数
        private Integer fouls;
        //致命失误导致丢球
        private Integer fatalError;
        //致命失误导致被射门
        private Integer seriousError;
        //致命失误次数
        private Integer errorsSum;
        //造越位次数
        private Integer offsideWon;
        //被射门次数
        private Integer shotsConceded;
        //传球次数
        private Integer passes;
        //准确传球次数
        private Integer accPasses;
        //传球成功率（百分比）
        private Double passSucc;
        //传中次数
        private Integer crosses;
        //准确传中次数
        private Integer accCrosses;
        //长传次数
        private Integer longBall;
        //准确长传次数
        private Integer accLB;
        //直塞次数
        private Integer thBall;
        //准确直塞次数
        private Integer accThB;
        //争顶成功次数
        private Integer aerialsWon;
        //争顶次数
        private Integer aerialsTotal;
        //争顶成功率（百分比）
        private Double aerialDuelScc;
        //防守对抗次数
        private Integer defensiveAerials;
        //进攻对抗次数
        private Integer offensiveAerials;
        //触球次数
        private Integer touches;
        //控球次数
        private Integer possessionNum;
        //控球率（百分比）
        private Double possession;
        //错失绝佳机会次数
        private Integer bigChanceMissed;
        //把握绝佳机会次数
        private Integer bigChanceScored;
        //创造绝佳机会次数
        private Integer bigChanceCreated;
        //夺回球权次数
        private Integer ballRecovery;
        //最后一道防线抢断成功
        private Integer lastManTackle;
        //门线救险
        private Integer clearOffLine;
        //后场传球次数
        private Integer defensiveThirdPass;
        //后场成功传球次数
        private Integer defensiveThirdPassAcc;
        //中场传球次数
        private Integer midThirdPass;
        //中场成功传球次数
        private Integer midThirdPassAcc;
        //前场传球次数
        private Integer finalThirdPass;
        //前场成功传球次数
        private Integer finalThirdPassAcc;
        //角球次数
        private Integer corners;
        //准确角球次数
        private Integer accCorners;
        //摘高空球次数
        private Integer claimsHigh;
        //扑救次数
        private Integer totalSaves;
    }

//    “id”: 10001,				//数据Id
//            “teamId”: 13,				//球队Id
//            “homeAway”: “home”,			//主队或客队（home:主队,away:客队）
//            “formation”: “442”,				//阵型
//            “rate”: 7.76,				//评分
//            “goals”: 5,					//进球
//            “goalsLost”: 0,				//丢球
//            “assists”: 5,				//助攻次数
//            “penaltyScored”: 0,			//点球得分
//            “penaltyMissd”: 0,			//射失点球
//            “penaltySaved”: 0,			//扑出点球
//            “yelCards”: 0,				//黄牌
//            “redCards”: 0,				//红牌
//            “shots”: 19, 				//射门次数
//            “shotsOT”: 10,				//射正次数
//            “shotsOffTag”: 4,			//射偏次数
//            “shotsBlocked”: 5,			//射门被封堵次数
//            “shotsOnPost”: 0,			//击中门框次数
//            “keyPasses”: 9,				//关键传球次数
//            “dribbles”: 16,				//成功过人次数
//            “dribblesAttempted”: 35,	//尝试过人次数
//            “dribblesSucc”: 45.71,		//过人成功率（百分比）
//            “dribbledPast”: 10, 		//被突破次数
//            “fouled”: 7,				//被侵犯次数
//            “offsides”: 1,				//越位次数
//            “disp”: 10,					//被抢断次数
//            “unsTouches”: 13,			//失误次数
//            “tackles”: 17,				//抢断成功次数
//            “tacklesAttempted”: 27,		//尝试抢断次数
//            “tacklesSucc”: 62.96,		//抢断成功率（百分比）
//            “interceptions”: 9,			//拦截次数
//            “clearances”: 18,			//解围次数
//            “blockShots”: 1,			//封堵射门次数
//            “fouls”: 5,					//犯规次数
//            “fatalError”: 0,			//致命失误导致丢球
//            “seriousError”: 0,			//致命失误导致被射门
//            “errorsSum”: 0,				//致命失误次数
//            “offsideWon”: 2,			//造越位次数
//            “shotsConceded”: 5,			//被射门次数
//            “passes”: 627,				//传球次数
//            “accPasses”: 534,			//准确传球次数
//            “passSucc”: 85.17,			//传球成功率（百分比）
//            “crosses”: 21,				//传中次数
//            “accCrosses”: 6,			//准确传中次数
//            “longBall”: 61,				//长传次数
//            “accLB”: 41,				//准确长传次数
//            “thBall”: 3,				//直塞次数
//            “accThB”: 1,				//准确直塞次数
//            “aerialsWon”: 9,			//争顶成功次数
//            “aerialsTotal”: 16,			//争顶次数
//            “aerialDuelScc”: 56.25,		//争顶成功率（百分比）
//            “defensiveAerials”: 7,		//防守对抗次数
//            “offensiveAerials”: 9,		//进攻对抗次数
//            “touches”: 843,				//触球次数
//            “possessionNum”: 654,		//控球次数
//            “possession”: 62.38,		//控球率（百分比）
//            “bigChanceMissed”: 0,		//错失绝佳机会次数
//            “bigChanceScored”: 4,		//把握绝佳机会次数
//            “bigChanceCreated”:4,		//创造绝佳机会次数
//            “ballRecovery”: 56,			//夺回球权次数
//            “lastManTackle”: 0,			//最后一道防线抢断成功
//            “clearOffLine”: 0,			//门线救险
//            “defensiveThirdPass”: 91,		//后场传球次数
//            “defensiveThirdPassAcc”: 89,	//后场成功传球次数
//            “midThirdPass”: 350,			//中场传球次数
//            “midThirdPassAcc”: 306,			//中场成功传球次数
//            “finalThirdPass”: 186,			//前场传球次数
//            “finalThirdPassAcc”: 139,		//前场成功传球次数
//            “corners”: 6,				//角球次数
//            “accCorners”: 4,			//准确角球次数
//            “claimsHigh”: 1,			//摘高空球次数
//            “totalSaves”: 3				//扑救次数
}
