package com.live.server.controller;

import com.live.common.domain.ResponseData;
import com.live.common.domain.dto.api.MatchBasketballOddsResponse;
import com.live.common.domain.dto.api.MatchFootballOddsResponse;
import com.live.common.domain.request.*;
import com.live.common.service.CategoryService;
import com.live.common.service.MatchService;
import io.swagger.annotations.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

@Slf4j
@CrossOrigin
@RestController
@RequestMapping("/match")
@Api(tags = "赛程接口 API 文档")
public class MatchController {

    @Resource
    private MatchService matchService;
    @Resource
    private CategoryService categoryService;

//    @PostMapping(value = "/getTitleTab")
//    @ApiOperation(value = "获取 sportsId 首页标题栏类型")
//    @ApiResponses({
//            @ApiResponse(code = 200, message = "成功处理请求"),
//            @ApiResponse(code = 401, message = "没有权限访问该服务"),
//            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
//            @ApiResponse(code = 404, message = "未发现该服务"),
//            @ApiResponse(code = 500, message = "服务器内部错误")
//    })
//    public ResponseData<?> getTitleTab(HttpServletRequest request) {
//        return categoryService.getTitleTab();
//    }
//
//    @PostMapping(value = "/getMatchSportsType")
//    @ApiOperation(value = "获取赛程详细分类")
//    @ApiResponses({
//            @ApiResponse(code = 200, message = "成功处理请求"),
//            @ApiResponse(code = 401, message = "没有权限访问该服务"),
//            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
//            @ApiResponse(code = 404, message = "未发现该服务"),
//            @ApiResponse(code = 500, message = "服务器内部错误")
//    })
//    public ResponseData<?> getMatchSportsType(HttpServletRequest request) {
//        return categoryService.getMatchSportsType();
//    }

    @PostMapping(value = "/getMatchHomeType")
    @ApiOperation(value = "获取比赛页赛程分类")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    public ResponseData<?> getMatchHomeType(HttpServletRequest request) {
        return categoryService.getMatchHomeType(request);
    }

    @PostMapping(value = "/customMadeTeam")
    @ApiOperation(value = "获取定制球队 -1 全部 0 足球 1 篮球")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    public ResponseData<?> customMadeTeam(@RequestBody CommonIntId commonIntId, HttpServletRequest request) {
        return categoryService.customMadeTeam(commonIntId, request);
    }

    @PostMapping(value = "/getMatchListBySportsId")
    @ApiOperation(value = "根据 sportsId 获取赛程列表(可带可不带token，带token判断关注)")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> getMatchListBySportsId(@RequestBody GetMatchListByRequest commonStringId, HttpServletRequest request) {
        return matchService.getMatchListBySportsId(commonStringId, request);
    }

//    @PostMapping(value = "/getMatchList")
//    @ApiOperation(value = "根据 sportsId 获取赛程列表(可带可不带token，带token判断预约)")
//    @ApiResponses({
//            @ApiResponse(code = 200, message = "成功处理请求"),
//            @ApiResponse(code = 401, message = "没有权限访问该服务"),
//            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
//            @ApiResponse(code = 404, message = "未发现该服务"),
//            @ApiResponse(code = 500, message = "服务器内部错误")
//    })
//    @ApiImplicitParams({
//            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
//    })
//    public ResponseData<?> getMatchList(@RequestBody GetMatchListRequest commonStringId, HttpServletRequest request) {
//        return matchService.getMatchList(commonStringId, request);
//    }

    @PostMapping(value = "/getMatchInfo")
    @ApiOperation(value = "获取赛事详情")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    public ResponseData<?> getMatchInfo(@RequestBody CommonStringId commonStringId, HttpServletRequest request) {
        return matchService.getMatchInfo(commonStringId, request);
    }

    @PostMapping(value = "/userReserveMatch")
    @ApiOperation(value = "用户关注比赛")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> userReserveMatch(@RequestBody CommonStringId commonStringId, HttpServletRequest request) {
        return matchService.userReserveMatch(commonStringId, request);
    }

    @PostMapping(value = "/userCancelReserveMatch")
    @ApiOperation(value = "用户取消预约比赛")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> userCancelReserveMatch(@RequestBody CommonStringId commonStringId, HttpServletRequest request) {
        return matchService.userCancelReserveMatch(commonStringId, request);
    }

    @PostMapping(value = "/userGetReserveMatch")
    @ApiOperation(value = "获取用户预约的比赛列表")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> userGetReserveMatch(@RequestBody CommonPage commonPage,HttpServletRequest request) {
        return matchService.userGetReserveMatch(commonPage, request);
    }

//    @PostMapping(value = "/userFollowAnchor")
//    @ApiOperation(value = "用户关注主播 房间ID")
//    @ApiResponses({
//            @ApiResponse(code = 200, message = "成功处理请求"),
//            @ApiResponse(code = 401, message = "没有权限访问该服务"),
//            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
//            @ApiResponse(code = 404, message = "未发现该服务"),
//            @ApiResponse(code = 500, message = "服务器内部错误")
//    })
//    @ApiImplicitParams({
//            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
//    })
//    public ResponseData<?> userFollowAnchor(@RequestBody CommonStringId commonIntId, HttpServletRequest request) {
//        return matchService.userFollowAnchor(commonIntId, request);
//    }
//
//    @PostMapping(value = "/userUnFollowAnchor")
//    @ApiOperation(value = "用户取消关注 房间ID")
//    @ApiResponses({
//            @ApiResponse(code = 200, message = "成功处理请求"),
//            @ApiResponse(code = 401, message = "没有权限访问该服务"),
//            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
//            @ApiResponse(code = 404, message = "未发现该服务"),
//            @ApiResponse(code = 500, message = "服务器内部错误")
//    })
//    @ApiImplicitParams({
//            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
//    })
//    public ResponseData<?> userUnFollowAnchor(@RequestBody CommonStringId commonIntId, HttpServletRequest request) {
//        return matchService.userUnFollowAnchor(commonIntId, request);
//    }
//
//    @PostMapping(value = "/userGetAnchorList")
//    @ApiOperation(value = "获取用户关注的主播列表")
//    @ApiResponses({
//            @ApiResponse(code = 200, message = "成功处理请求"),
//            @ApiResponse(code = 401, message = "没有权限访问该服务"),
//            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
//            @ApiResponse(code = 404, message = "未发现该服务"),
//            @ApiResponse(code = 500, message = "服务器内部错误")
//    })
//    @ApiImplicitParams({
//            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
//    })
//    public ResponseData<?> userGetAnchorList(HttpServletRequest request) {
//        return matchService.userGetAnchorList(request);
//    }

    @PostMapping(value = "/matchInfoBasketball")
    @ApiOperation(value = "根据ID获取赛事详情 篮球 接口")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    public ResponseData<?> matchInfoBasketball(@RequestBody CommonStringId commonIntId, HttpServletRequest request) {
        return matchService.matchInfoBasketball(commonIntId, request);
    }

    @PostMapping(value = "/matchInfoFootball")
    @ApiOperation(value = "根据ID获取赛事详情 足球 接口")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    public ResponseData<?> matchInfoFootball(@RequestBody CommonStringId commonIntId, HttpServletRequest request) {
        return matchService.matchInfoFootball(commonIntId, request);
    }

    @PostMapping(value = "/getMatchSummaryById")
    @ApiOperation(value = "根据ID获取赛事直播概况 篮球足球通用")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    public ResponseData<?> getMatchSummaryById(@RequestBody MatchSummaryRequest commonIntId) {
        return matchService.getMatchSummaryById(commonIntId);
    }

    @PostMapping(value = "/getMatchLiveList")
    @ApiOperation(value = "根据赛事ID获取 播放源")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    public ResponseData<?> getMatchLiveList(@RequestBody CommonStringId commonStringId) {
        return matchService.getMatchLiveList(commonStringId);
    }

    @PostMapping(value = "/matchFootballOdds")
    @ApiOperation(value = "根据ID获取各家指数/赔率 【足球】 接口")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    public ResponseData<MatchFootballOddsResponse> matchFootballOdds(@RequestBody CommonStringId commonIntId, HttpServletRequest request) {
        return matchService.matchFootballOdds(commonIntId, request);
    }

    @PostMapping(value = "/matchBasketballOdds")
    @ApiOperation(value = "根据ID获取各家指数/赔率 【篮球】 接口")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    public ResponseData<MatchBasketballOddsResponse> matchBasketballOdds(@RequestBody CommonStringId commonIntId, HttpServletRequest request) {
        return matchService.matchBasketballOdds(commonIntId, request);
    }

    @PostMapping(value = "/getMatchNewsById")
    @ApiOperation(value = "根据赛事 ID 获取相关资讯，不区分篮球足球")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    public ResponseData<?> getMatchNewsById(@RequestBody GetMatchNewsByIdRequest getMatchNewsById, HttpServletRequest request) {
        return matchService.getMatchNewsById(getMatchNewsById, request);
    }

    @PostMapping(value = "/getHotRankList")
    @ApiOperation(value = "根据赛事 ID 获取红榜列表，不区分篮球足球")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    public ResponseData<?> getHotRankList(@RequestBody GetMatchNewsByIdRequest matchNewsByIdRequest, HttpServletRequest request) {
        return matchService.getHotRankList(matchNewsByIdRequest, request);
    }

    @PostMapping(value = "/getHotRankInfoById")
    @ApiOperation(value = "根据红榜 ID 获取详情")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    public ResponseData<?> getHotRankInfoById(@RequestBody CommonIntId commonIntId, HttpServletRequest request) {
        return matchService.getHotRankInfoById(commonIntId, request);
    }

    @PostMapping(value = "/getHotRankAssociate")
    @ApiOperation(value = "根据红榜 ID 获取相关红榜")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    public ResponseData<?> getHotRankAssociate(@RequestBody RankAssociateRequest commonIntId, HttpServletRequest request) {
        return matchService.getHotRankAssociate(commonIntId, request);
    }
}
