package com.live.common.domain.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.*;
import lombok.experimental.SuperBuilder;

import java.util.Date;

@EqualsAndHashCode(callSuper = true)
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@TableName("t_match")
public class Match extends BaseStringIdEntity {

    private String sportsId;

    private String homeId;
    private Integer homeScore;

    private String awayId;
    private Integer awayScore;

    private Date matchTime;

    private String crawlUrl;

    //主队比赛记录ID
    private String competitionHomeId;
    //客队比赛记录ID
    private String competitionAwayId;
    private String competitionName;
    private String competitionShortName;
    //竞赛状态1正在进行 2未开始 3完场 4 未知
    private int competitionStatus;

    //赛事标签拼接
    private String categoryId;

    //0乐鱼 1AlStat
    private Integer sourceType;
    //默认 0 热门 1
    private Integer hot;

}
