package com.live.job.entity.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class AlStatFootballEventDto {

    private String state;
    private List<AlStatFootballStatMatchDto> matchs;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class AlStatFootballStatMatchDto {
        private Integer id;
        private String startTime;
        private Integer homeTeamId;
        private String homeTeamName;
        private Integer awayTeamId;
        private String awayTeamName;
        private List<AlStatFootballStatInfoDto> liveTimelines;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class AlStatFootballStatInfoDto {
        private Integer id;
        //比赛事件类型（具体定义参考文件-个别名词解释）
        private Integer eventType;
        //比赛阶段（具体定义参考文件-个别名词解释）
        private Integer period;
        //分钟数
        private Integer minute;
        //秒数
        private Integer second;
        private Integer teamId;
        private Integer playerId;
        private String playerName;
        //关联球员Id
        private Integer relatedPlayerId;
        //关联球员名称
        private String relatedPlayerName;
        //事件文字描述
        private String description;
        //事件文字描述（英文）
        private String descriptionEn;
        //比分
        private String score;
    }

    public static String channelEventType(Integer eventType){
        switch (eventType){
            case 0:
                return "进球";
            case 1:
                return "助攻";
            case 2:
                return "击中门框";
            case 3:
                return "踢进乌龙球";
            case 4:
                return "点球得分";
            case 5:
                return "射失点球";
            case 6:
                return "扑出点球";
            case 7:
            case 8:
                return "得到一张黄牌";
            case 9:
                return "得到第二张黄牌，被罚下";
            case 10:
                return "被红牌直接罚下";
            case 11:
                return "替换下场";
            case 12:
                return "替补登场";
            case 13:
                return "最后一道防线抢断成功";
            case 14:
                return "门线救险";
            case 15:
                return "致命失误导致丢球";
            case 16:
                return "致命失误导致被射门";
            case 17:
                return "点球命中（点球大战）";
            case 18:
                return "射失点球（点球大战）";
            default:
                return "未知事件";
        }
    }

}
