package com.live.common.domain.dto.api;

import com.live.common.domain.ResultPage;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GetPlayerListResponse {

    private List<GetPlayerInfoResponse> hotPlayer;

    private ResultPage<List<GetPlayerInfoResponse>> otherPlayer;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class GetPlayerInfoResponse {
        private Integer id;
        private Integer sportsId;
        private String name;
        private String nameEn;
        private String icon;
    }

}
