package com.live.console.controller;

import com.live.common.domain.ResponseData;
import com.live.common.domain.request.CommonPage;
import com.live.common.domain.request.CommonStringId;
import com.live.common.domain.request.back.BackGetUserRequest;
import com.live.common.domain.request.back.CreateAccountRequest;
import com.live.common.domain.request.back.EditApplyAnchorRequest;
import com.live.common.domain.request.back.EditUserInfoBackRequest;
import com.live.common.service.UserService;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

@CrossOrigin
@RestController
@RequestMapping("/backUser")
@Api(tags = "后台用户管理接口")
public class BackUserController {

    @Resource
    private UserService userService;

    @PostMapping(value = "/backGetUserList")
    @ApiOperation(value = "获取用户列表")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> backGetUserList(@RequestBody BackGetUserRequest backGetUserRequest, HttpServletRequest request) {
        return userService.getUserList(backGetUserRequest, request);
    }

    @PostMapping(value = "/editUserInfo")
    @ApiOperation(value = "修改用户信息")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> editUserInfoBack(@RequestBody EditUserInfoBackRequest editUserInfoRequest, HttpServletRequest request) {
        return userService.editUserInfoBack(editUserInfoRequest, request);
    }

    @PostMapping(value = "/delUserById")
    @ApiOperation(value = "根据ID删除用户")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> delUserById(@RequestBody CommonStringId stringId, HttpServletRequest request) {
        return userService.delUserById(stringId, request);
    }

    @PostMapping(value = "/userApplyAnchorList")
    @ApiOperation(value = "获取用户申请主播列表")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> userApplyAnchorList(@RequestBody CommonPage commonPage, HttpServletRequest request) {
        return userService.userApplyAnchorList(commonPage, request);
    }

    @PostMapping(value = "/editUserApply")
    @ApiOperation(value = "0 通过 1 拒绝 用户主播申请")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> editUserApply(@RequestBody EditApplyAnchorRequest applyAnchorRequest, HttpServletRequest request) {
        return userService.editUserApply(applyAnchorRequest, request);
    }

    @PostMapping(value = "/createAccount")
    @ApiOperation(value = "创建 用户/主播 账户", notes = "accountRequest.getType()")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> createAccount(@RequestBody CreateAccountRequest accountRequest, HttpServletRequest request) {
        return userService.createAccount(accountRequest);
    }

}