package com.live.common.domain.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.*;
import lombok.experimental.SuperBuilder;

import java.util.Date;

@EqualsAndHashCode(callSuper = true)
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@TableName("t_user")
public class User extends BaseStringIdEntity {

    private String userName;

    private String phone;

    private String ip;

    private String deviceId;

    /**
     * 0:普通用户  1：主播 2游客
     */
    private int type;

    /**
     * 描述
     */
    private String userDesc;
    /**
     * '头像'
     */
    private String userIcon;
    /**
     * 渠道
     */
    private Integer channel;
    /**
     * 0:正规用户注册  1:文章作者 / 小编 2,补缺主播
     */
    private Integer role;

    private String reason;
    //0保密1男2女
    private int sex;

    private Date birthday;
    private Integer level;

    //0 不是 1是热门主播
    private Integer hotAnchor;

    //主播热度
    private Integer hotNum;

    //登录密码
    private String password;

    private String realName;

    private String idCard;

    private String cardPhotoPositive;

    private String cardPhotoReverse;
}
