package com.live.common.service.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.live.common.domain.ResponseData;
import com.live.common.domain.ResultPage;
import com.live.common.domain.dto.back.TeamBackResponse;
import com.live.common.domain.entity.Team;
import com.live.common.domain.request.CommonPage;
import com.live.common.mapper.TeamMapper;
import com.live.common.service.TeamService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Service
public class TeamServiceImpl implements TeamService {

    @Resource
    private TeamMapper teamMapper;

    @Override
    public ResponseData<?> getTeamList(CommonPage commonPage, HttpServletRequest request) {
        int jumpNum = (commonPage.getPageNum() - 1) * commonPage.getPageSize();

        long count = teamMapper.selectCount(Wrappers.<Team>lambdaQuery()
                .eq(Team::getDeleted, 0)
        );

        List<Team> teams = teamMapper.selectList(Wrappers.<Team>lambdaQuery()
                .eq(Team::getDeleted, 0)
                .orderByDesc(Team::getCreateTime)
                .last(String.format(" limit %s,%s", jumpNum, commonPage.getPageSize()))
        );

        List<TeamBackResponse> responses = teams.stream().map(b -> TeamBackResponse.builder()
                .id(b.getId())
                .teamIcon(b.getTeamIcon())
                .teamName(b.getTeamName())
                .teamNameEn(b.getTeamNameEn())
                .build())
                .collect(Collectors.toList());
        return ResponseData.successResponse(new ResultPage<>(commonPage.getPageNum(), commonPage.getPageSize(), (int) count, responses));
    }

    @Override
    public ResponseData<?> editTeam(TeamBackResponse teamBackResponse, HttpServletRequest request) {
        if(StringUtils.isBlank(teamBackResponse.getId())){
            teamMapper.insert(Team.builder()
                    .teamIcon(teamBackResponse.getTeamIcon())
                    .teamName(teamBackResponse.getTeamName())
                    .teamNameEn(teamBackResponse.getTeamNameEn())
                    .build());
        } else {
            Team team = teamMapper.selectById(teamBackResponse.getId());
            if(team == null){
                return ResponseData.fail400Response("ID错误,队伍不存在");
            }
            if(StringUtils.isNotBlank(teamBackResponse.getTeamIcon())){
                team.setTeamIcon(teamBackResponse.getTeamIcon());
            }
            if(StringUtils.isNotBlank(teamBackResponse.getTeamName())){
                team.setTeamName(teamBackResponse.getTeamName());
            }
            if(StringUtils.isNotBlank(teamBackResponse.getTeamNameEn())){
                team.setTeamNameEn(teamBackResponse.getTeamNameEn());
            }
            teamMapper.updateById(team);
        }
        return ResponseData.successResponse();
    }

}
